
INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01217, '6.2', 'drop-fk-constraint-on-profile_component_visibility', 'BUGFIX', 'Drops an FK constraint which is not needed anymore. See #1709 for details.', now());

BEGIN; 

CREATE OR REPLACE FUNCTION DROPCONSTRAINT(tblSchema VARCHAR, tblName 
VARCHAR, cstName VARCHAR) RETURNS void AS $$
DECLARE
     exec_string TEXT;
BEGIN
     exec_string := 'ALTER TABLE ';
     IF tblSchema != NULL THEN
         exec_string := exec_string || quote_ident(tblSchema) || '.';
     END IF;
     exec_string := exec_string || quote_ident(tblName)
         || ' DROP CONSTRAINT '
         || quote_ident(cstName);
     EXECUTE exec_string;
EXCEPTION
     WHEN OTHERS THEN
         NULL;
END;
$$ LANGUAGE plpgsql;


select DROPCONSTRAINT(null, 'profile_component_visibility', 'profile_component_visibility_component_type_fkey');

COMMIT;
