BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01209, '5.11', 'update-toolbar-colums-again', 'FEATURE', 'update-toolbar-colums-again', now());

-- Old default:
-- [["Templates","FitWindow","-","Cut","Copy","Paste","PasteText","PasteWord","Image","Table","Rule","Source"],["Undo","Redo","Bold","Italic","Underline","StrikeThrough","-","OrderedList","UnorderedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyFull"],["FontFormat","FontSize","TextColor","BGColor","RemoveFormat","-","JustConnectOpenLinkPopup","Unlink","Anchor"]]

ALTER TABLE entity_type ALTER COLUMN toolbar_infowidget SET DEFAULT '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]';
ALTER TABLE entity_type ALTER COLUMN toolbar_newsblog SET DEFAULT   '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]';
ALTER TABLE entity_type ALTER COLUMN toolbar_raweditor SET DEFAULT  '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]';
ALTER TABLE entity_type ALTER COLUMN toolbar_wiki SET DEFAULT       '[["Templates","Maximize","-","Cut","Copy","Paste","PasteText","PasteFromWord","Image","Table","HorizontalRule","Source"],["Undo","Redo","Bold","Italic","Underline","Strike","-","NumberedList","BulletedList","Outdent","Indent","-","JustifyLeft","JustifyCenter","JustifyRight","JustifyBlock"],["Format","FontSize","TextColor","BGColor","RemoveFormat","-","Link","Unlink","Anchor"]]';


-- ' -> "
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, '''', '"');
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, '''', '"');
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, '''', '"');
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, '''', '"');

-- PasteWord -> PasteFromWord
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"PasteWord"$$, $$"PasteFromWord"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"PasteWord"$$, $$"PasteFromWord"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"PasteWord"$$, $$"PasteFromWord"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"PasteWord"$$, $$"PasteFromWord"$$);

-- Rule -> HorizontalRule
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"Rule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"Rule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"Rule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"Rule"$$, $$"HorizontalRule"$$);

-- StrikeThrough -> Strike
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"StrikeThrough"$$, $$"Strike"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"StrikeThrough"$$, $$"Strike"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"StrikeThrough"$$, $$"Strike"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"StrikeThrough"$$, $$"Strike"$$);

-- OrderedList -> NumberedList
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"OrderedList"$$, $$"NumberedList"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"OrderedList"$$, $$"NumberedList"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"OrderedList"$$, $$"NumberedList"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"OrderedList"$$, $$"NumberedList"$$);

-- UnorderedList -> BulletedList
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"UnorderedList"$$, $$"BulletedList"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"UnorderedList"$$, $$"BulletedList"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"UnorderedList"$$, $$"BulletedList"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"UnorderedList"$$, $$"BulletedList"$$);

-- JustifyFull -> JustifyBlock
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"JustifyFull"$$, $$"JustifyBlock"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"JustifyFull"$$, $$"JustifyBlock"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"JustifyFull"$$, $$"JustifyBlock"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"JustifyFull"$$, $$"JustifyBlock"$$);

-- FontFormat -> JustifyBlock
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"FontFormat"$$, $$"Format"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"FontFormat"$$, $$"Format"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"FontFormat"$$, $$"Format"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"FontFormat"$$, $$"Format"$$);

-- JustConnectImage -> Image
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"JustConnectImage"$$, $$"Image"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"JustConnectImage"$$, $$"Image"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"JustConnectImage"$$, $$"Image"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"JustConnectImage"$$, $$"Image"$$);

-- JustConnectOpenLinkPopup -> Link
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"JustConnectOpenLinkPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"JustConnectOpenLinkPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"JustConnectOpenLinkPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"JustConnectOpenLinkPopup"$$, $$"Link"$$);

-- (repair broken toolbar created by older scripts)

-- JustConnectOpenJustConnectOpenLinkPopupPopup -> Link
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"JustConnectOpenJustConnectOpenLinkPopupPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"JustConnectOpenJustConnectOpenLinkPopupPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"JustConnectOpenJustConnectOpenLinkPopupPopup"$$, $$"Link"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"JustConnectOpenJustConnectOpenLinkPopupPopup"$$, $$"Link"$$);

-- HorizontalHorizontalHorizontalRule -> HorizontalRule
UPDATE entity_type SET toolbar_infowidget = replace(toolbar_infowidget, $$"HorizontalHorizontalHorizontalRule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_newsblog = replace(toolbar_newsblog, $$"HorizontalHorizontalHorizontalRule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_raweditor = replace(toolbar_raweditor, $$"HorizontalHorizontalHorizontalRule"$$, $$"HorizontalRule"$$);
UPDATE entity_type SET toolbar_wiki = replace(toolbar_wiki, $$"HorizontalHorizontalHorizontalRule"$$, $$"HorizontalRule"$$);

COMMIT;

