/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.clear.impl;

public class MultiPassErrorHandler {
    private int numPasses;
    private RuntimeException firstException;
    private int exceptionsThisPass;
    private int exceptionsLastPass;
    private boolean exceptionsDecreasing;

    public void addError(RuntimeException exception) {
        if (this.firstException == null) {
            this.firstException = exception;
        }
        ++this.exceptionsThisPass;
    }

    public boolean continueExecutionAfterPass() {
        this.recordResultOfPass();
        boolean continueExecution = this.checkContinueExecution();
        this.resetForNextpass();
        return continueExecution;
    }

    private void recordResultOfPass() {
        ++this.numPasses;
        this.exceptionsDecreasing = this.exceptionsThisPass < this.exceptionsLastPass;
    }

    private boolean checkContinueExecution() {
        if (this.numPasses > 1 && !this.exceptionsDecreasing) {
            throw this.firstException;
        }
        boolean continueExecution = this.exceptionsThisPass == 0 ? false : (this.numPasses == 1 && this.exceptionsThisPass > 0 ? true : this.exceptionsDecreasing);
        return continueExecution;
    }

    private void resetForNextpass() {
        this.exceptionsLastPass = this.exceptionsThisPass;
        this.exceptionsThisPass = 0;
        this.firstException = null;
    }
}

