/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.structure.clear.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.Databases;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.structure.clear.DBClearer;
import org.dbmaintain.structure.clear.impl.MultiPassErrorHandler;
import org.dbmaintain.structure.constraint.ConstraintsDisabler;
import org.dbmaintain.structure.model.DbItemIdentifier;
import org.dbmaintain.structure.model.DbItemType;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBClearer
implements DBClearer {
    private static Log logger = LogFactory.getLog(DefaultDBClearer.class);
    protected ConstraintsDisabler constraintsDisabler;
    protected ExecutedScriptInfoSource executedScriptInfoSource;
    protected Set<DbItemIdentifier> itemsToPreserve = new HashSet<DbItemIdentifier>();
    protected Databases databases;
    private MultiPassErrorHandler multiPassErrorHandler;

    public DefaultDBClearer(Databases databases, Set<DbItemIdentifier> itemsToPreserve, ConstraintsDisabler constraintsDisabler, ExecutedScriptInfoSource executedScriptInfoSource) {
        this.databases = databases;
        this.itemsToPreserve = itemsToPreserve;
        this.constraintsDisabler = constraintsDisabler;
        this.executedScriptInfoSource = executedScriptInfoSource;
        this.assertItemsToPreserveExist(itemsToPreserve);
    }

    @Override
    public void clearDatabase() {
        this.executedScriptInfoSource.clearAllExecutedScripts();
        this.constraintsDisabler.disableReferentialConstraints();
        for (Database database : this.databases.getDatabases()) {
            if (database == null) continue;
            this.clearDatabase(database);
        }
    }

    protected void clearDatabase(Database database) {
        for (String schemaName : database.getSchemaNames()) {
            this.multiPassErrorHandler = new MultiPassErrorHandler();
            if (this.itemsToPreserve.contains(DbItemIdentifier.getSchemaIdentifier(schemaName, database))) continue;
            logger.info("Clearing database schema " + schemaName);
            do {
                this.dropSynonyms(database, schemaName);
                this.dropViews(database, schemaName);
                this.dropMaterializedViews(database, schemaName);
                this.dropSequences(database, schemaName);
                this.dropTables(database, schemaName);
                this.dropStoredProcedures(database, schemaName);
                this.dropTriggers(database, schemaName);
                this.dropTypes(database, schemaName);
                this.dropRules(database, schemaName);
            } while (this.multiPassErrorHandler.continueExecutionAfterPass());
        }
    }

    protected void dropTables(Database database, String schemaName) {
        Set<String> tableNames = database.getTableNames(schemaName);
        for (String tableName : tableNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.TABLE, schemaName, tableName, database))) continue;
            logger.debug("Dropping table " + tableName + " in database schema " + schemaName);
            try {
                database.dropTable(schemaName, tableName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropViews(Database database, String schemaName) {
        Set<String> viewNames = database.getViewNames(schemaName);
        for (String viewName : viewNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.VIEW, schemaName, viewName, database))) continue;
            logger.debug("Dropping view " + viewName + " in database schema " + schemaName);
            try {
                database.dropView(schemaName, viewName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropMaterializedViews(Database database, String schemaName) {
        if (!database.supportsMaterializedViews()) {
            return;
        }
        Set<String> materializedViewNames = database.getMaterializedViewNames(schemaName);
        for (String materializedViewName : materializedViewNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.MATERIALIZED_VIEW, schemaName, materializedViewName, database))) continue;
            logger.debug("Dropping materialized view " + materializedViewName + " in database schema " + schemaName);
            try {
                database.dropMaterializedView(schemaName, materializedViewName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropSynonyms(Database database, String schemaName) {
        if (!database.supportsSynonyms()) {
            return;
        }
        Set<String> synonymNames = database.getSynonymNames(schemaName);
        for (String synonymName : synonymNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.SYNONYM, schemaName, synonymName, database))) continue;
            logger.debug("Dropping synonym " + synonymName + " in database schema " + schemaName);
            try {
                database.dropSynonym(schemaName, synonymName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropSequences(Database database, String schemaName) {
        if (!database.supportsSequences()) {
            return;
        }
        Set<String> sequenceNames = database.getSequenceNames(schemaName);
        for (String sequenceName : sequenceNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.SEQUENCE, schemaName, sequenceName, database))) continue;
            logger.debug("Dropping sequence " + sequenceName + " in database schema " + schemaName);
            try {
                database.dropSequence(schemaName, sequenceName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropTriggers(Database database, String schemaName) {
        if (!database.supportsTriggers()) {
            return;
        }
        Set<String> triggerNames = database.getTriggerNames(schemaName);
        for (String triggerName : triggerNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.TRIGGER, schemaName, triggerName, database))) continue;
            logger.debug("Dropping trigger " + triggerName + " in database schema " + schemaName);
            try {
                database.dropTrigger(schemaName, triggerName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropStoredProcedures(Database database, String schemaName) {
        if (!database.supportsStoredProcedures()) {
            return;
        }
        Set<String> storedProcedureNames = database.getStoredProcedureNames(schemaName);
        for (String storedProcedureName : storedProcedureNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.STORED_PROC, schemaName, storedProcedureName, database))) continue;
            logger.debug("Dropping stored procedure " + storedProcedureName + " in database schema " + schemaName);
            try {
                database.dropStoredProcedure(schemaName, storedProcedureName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropTypes(Database database, String schemaName) {
        if (!database.supportsTypes()) {
            return;
        }
        Set<String> typeNames = database.getTypeNames(schemaName);
        for (String typeName : typeNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.TYPE, schemaName, typeName, database))) continue;
            logger.debug("Dropping type " + typeName + " in database schema " + schemaName);
            try {
                database.dropType(schemaName, typeName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void dropRules(Database database, String schemaName) {
        if (!database.supportsRules()) {
            return;
        }
        Set<String> ruleNames = database.getRuleNames(schemaName);
        for (String ruleName : ruleNames) {
            if (this.itemsToPreserve.contains(DbItemIdentifier.getItemIdentifier(DbItemType.TYPE, schemaName, ruleName, database))) continue;
            logger.debug("Dropping rule " + ruleName + " in database schema " + schemaName);
            try {
                database.dropRule(schemaName, ruleName);
            }
            catch (RuntimeException e) {
                this.multiPassErrorHandler.addError(e);
            }
        }
    }

    protected void assertItemsToPreserveExist(Set<DbItemIdentifier> itemsToPreserve) {
        HashMap<DbItemIdentifier, Set<DbItemIdentifier>> schemaTables = new HashMap<DbItemIdentifier, Set<DbItemIdentifier>>();
        HashMap<DbItemIdentifier, Set<DbItemIdentifier>> schemaViews = new HashMap<DbItemIdentifier, Set<DbItemIdentifier>>();
        HashMap schemaMaterializedViews = new HashMap();
        HashMap schemaSequences = new HashMap();
        HashMap schemaSynonyms = new HashMap();
        HashMap schemaTriggers = new HashMap();
        HashMap schemaTypes = new HashMap();
        for (DbItemIdentifier itemToPreserve : itemsToPreserve) {
            Database database = this.databases.getDatabase(itemToPreserve.getDatabaseName());
            if (database == null) continue;
            switch (itemToPreserve.getType()) {
                case SCHEMA: {
                    if (database.getSchemaNames().contains(itemToPreserve.getSchemaName())) break;
                    throw new DbMaintainException("Schema to preserve does not exist: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which schema's need to be preserved. To assure nothing is dropped by mistake, no schema's will be dropped.");
                }
                case TABLE: {
                    Set<DbItemIdentifier> tableNames = (Set<DbItemIdentifier>)schemaTables.get(itemToPreserve.getSchema());
                    if (tableNames == null) {
                        tableNames = this.toDbItemIdentifiers(DbItemType.TABLE, database, itemToPreserve.getSchemaName(), database.getTableNames(itemToPreserve.getSchemaName()));
                        schemaTables.put(itemToPreserve.getSchema(), tableNames);
                    }
                    if (itemToPreserve.isDbMaintainIdentifier() || tableNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Table to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which tables need to be preserved. To assure nothing is dropped by mistake, no tables will be dropped.");
                }
                case VIEW: {
                    Set<DbItemIdentifier> viewNames = (Set<DbItemIdentifier>)schemaViews.get(itemToPreserve.getSchema());
                    if (viewNames == null) {
                        viewNames = this.toDbItemIdentifiers(DbItemType.VIEW, database, itemToPreserve.getSchemaName(), database.getViewNames(itemToPreserve.getSchemaName()));
                        schemaViews.put(itemToPreserve.getSchema(), viewNames);
                    }
                    if (viewNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("View to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which views need to be preserved. To assure nothing is dropped by mistake, no views will be dropped.");
                }
                case MATERIALIZED_VIEW: {
                    Set<Object> materializedViewNames = (Set)schemaMaterializedViews.get(itemToPreserve.getSchema());
                    if (materializedViewNames == null) {
                        materializedViewNames = database.supportsMaterializedViews() ? this.toDbItemIdentifiers(DbItemType.MATERIALIZED_VIEW, database, itemToPreserve.getSchemaName(), database.getMaterializedViewNames(itemToPreserve.getSchemaName())) : Collections.emptySet();
                        schemaMaterializedViews.put(itemToPreserve.getSchema(), materializedViewNames);
                    }
                    if (materializedViewNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Materialized view to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which materialized views need to be preserved. To assure nothing is dropped by mistake, no materialized views will be dropped.");
                }
                case SEQUENCE: {
                    Set<Object> sequenceNames = (Set)schemaSequences.get(itemToPreserve.getSchema());
                    if (sequenceNames == null) {
                        sequenceNames = database.supportsSequences() ? this.toDbItemIdentifiers(DbItemType.SEQUENCE, database, itemToPreserve.getSchemaName(), database.getSequenceNames(itemToPreserve.getSchemaName())) : Collections.emptySet();
                        schemaSequences.put(itemToPreserve.getSchema(), sequenceNames);
                    }
                    if (sequenceNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Sequence to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which sequences need to be preserved. To assure nothing is dropped by mistake, no sequences will be dropped.");
                }
                case SYNONYM: {
                    Set<Object> synonymNames = (Set)schemaSynonyms.get(itemToPreserve.getSchema());
                    if (synonymNames == null) {
                        synonymNames = database.supportsSynonyms() ? this.toDbItemIdentifiers(DbItemType.SYNONYM, database, itemToPreserve.getSchemaName(), database.getSynonymNames(itemToPreserve.getSchemaName())) : Collections.emptySet();
                        schemaSynonyms.put(itemToPreserve.getSchema(), synonymNames);
                    }
                    if (synonymNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Synonym to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which synonyms need to be preserved. To assure nothing is dropped by mistake, no synonyms will be dropped.");
                }
                case TRIGGER: {
                    Set<Object> triggerNames = (Set)schemaTriggers.get(itemToPreserve.getSchema());
                    if (triggerNames == null) {
                        triggerNames = database.supportsTriggers() ? this.toDbItemIdentifiers(DbItemType.TRIGGER, database, itemToPreserve.getSchemaName(), database.getTriggerNames(itemToPreserve.getSchemaName())) : Collections.emptySet();
                        schemaTriggers.put(itemToPreserve.getSchema(), triggerNames);
                    }
                    if (triggerNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Trigger to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which triggers need to be preserved. To assure nothing is dropped by mistake, no triggers will be dropped.");
                }
                case TYPE: {
                    Set<Object> typeNames = (Set)schemaTypes.get(itemToPreserve.getSchema());
                    if (typeNames == null) {
                        typeNames = database.supportsTypes() ? this.toDbItemIdentifiers(DbItemType.TYPE, database, itemToPreserve.getSchemaName(), database.getTypeNames(itemToPreserve.getSchemaName())) : Collections.emptySet();
                        schemaTypes.put(itemToPreserve.getSchema(), typeNames);
                    }
                    if (typeNames.contains(itemToPreserve)) break;
                    throw new DbMaintainException("Type to preserve does not exist: " + itemToPreserve.getItemName() + " in schema: " + itemToPreserve.getSchemaName() + ".\nDbMaintain cannot determine which types need to be preserved. To assure nothing is dropped by mistake, no types will be dropped.");
                }
            }
        }
    }

    protected Set<DbItemIdentifier> toDbItemIdentifiers(DbItemType type, Database database, String schemaName, Set<String> itemNames) {
        HashSet<DbItemIdentifier> result = new HashSet<DbItemIdentifier>();
        for (String itemName : itemNames) {
            result.add(DbItemIdentifier.getItemIdentifier(type, schemaName, itemName, database));
        }
        return result;
    }
}

