/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;
import thirdparty.org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSqlDatabase
extends Database {
    public MsSqlDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "mssql";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.name from sys.tables t, sys.schemas s where t.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select c.name from sys.columns c, sys.tables t, sys.schemas s where c.object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select v.name from sys.views v, sys.schemas s where v.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getSynonymNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select o.name from sys.synonyms o, sys.schemas s where o.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.name from sys.triggers t, sys.all_objects o, sys.schemas s where t.parent_id = o.object_id and o.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getStoredProcedureNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("SELECT sys.procedures.name FROM sys.procedures INNER JOIN sys.schemas ON sys.procedures.schema_id = sys.schemas.schema_id where sys.schemas.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTypeNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select t.name from sys.types t, sys.schemas s where t.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getRuleNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("SELECT ao.name FROM sys.all_objects ao INNER JOIN sys.schemas s ON s.schema_id = ao.schema_id WHERE type = 'R' and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getIdentityColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select i.name from sys.identity_columns i, sys.tables t, sys.schemas s where i.object_id = t.object_id and t.name = '" + tableName + "' and t.schema_id = s.schema_id and s.name = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void incrementIdentityColumnToValue(String schemaName, String tableName, String identityColumnName, long identityValue) {
        this.getSQLHandler().execute("DBCC CHECKIDENT ('" + this.qualified(schemaName, tableName) + "', reseed, " + identityValue + ")", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select t.name as tablename, f.name as constraintname from sys.foreign_keys f, sys.tables t, sys.schemas s where f.parent_object_id = t.object_id and t.schema_id = s.schema_id and s.name = '" + schemaName + "' and f.is_disabled = 0");
            while (resultSet.next()) {
                String tableName = resultSet.getString("tablename");
                String constraintName = resultSet.getString("constraintname");
                alterStatement.executeUpdate("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable referential constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        this.disableUniqueConstraints(schemaName);
        this.disableCheckConstraints(schemaName);
        this.disableNotNullConstraints(schemaName);
    }

    public void disableUniqueConstraints(String schemaName) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select t.name as tablename, k.name as constraintname from sys.key_constraints k, sys.tables t, sys.schemas s where k.type = 'UQ' and k.parent_object_id = t.object_id and t.schema_id = s.schema_id and s.name = '" + schemaName + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("tablename");
                String constraintName = resultSet.getString("constraintname");
                alterStatement.executeUpdate("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable referential constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    public void disableCheckConstraints(String schemaName) {
        Connection connection = null;
        Statement queryStatement = null;
        Statement alterStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            queryStatement = connection.createStatement();
            alterStatement = connection.createStatement();
            resultSet = queryStatement.executeQuery("select t.name as tablename, c.name as constraintname from sys.check_constraints c, sys.tables t, sys.schemas s where c.parent_object_id = t.object_id and t.schema_id = s.schema_id and s.name = '" + schemaName + "' and is_disabled = 0");
            while (resultSet.next()) {
                String tableName = resultSet.getString("tablename");
                String constraintName = resultSet.getString("constraintname");
                alterStatement.executeUpdate("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName));
            }
        }
        catch (SQLException e) {
            try {
                throw new DatabaseException("Unable to disable referential constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(queryStatement);
                DbUtils.closeQuietly(connection, alterStatement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(queryStatement);
        DbUtils.closeQuietly(connection, alterStatement, resultSet);
    }

    public void disableNotNullConstraints(String schemaName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Map<String, Set<String>> tablePrimaryKeyColumnsMap = this.getTablePrimaryKeyColumnsMap(schemaName);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select t.name table_name, c.name column_name, upper(y.name) data_type, c.max_length, c.precision, c.scale from sys.types y, sys.columns c, sys.tables t, sys.schemas s where c.is_nullable = 0 and c.is_rowguidcol = 0 and c.is_identity = 0 and c.is_computed = 0 and y.user_type_id = c.user_type_id and c.object_id = t.object_id and t.schema_id = s.schema_id and s.name = '" + schemaName + "'");
            while (resultSet.next()) {
                String dataType;
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                Set<String> primaryKeyColumnNames = tablePrimaryKeyColumnsMap.get(tableName);
                if (primaryKeyColumnNames != null && primaryKeyColumnNames.contains(columnName) || "TIMESTAMP".equals(dataType = resultSet.getString("data_type"))) continue;
                if ("NUMERIC".equals(dataType) || "DECIMAL".equals(dataType)) {
                    String precision = resultSet.getString("precision");
                    String scale = resultSet.getString("scale");
                    dataType = dataType + "(" + precision + ", " + scale + ")";
                } else if (dataType.contains("CHAR") || dataType.contains("BINARY")) {
                    String maxLength = resultSet.getString("max_length");
                    if (dataType.equals("NCHAR") || dataType.equals("NVARCHAR")) {
                        maxLength = String.valueOf(Integer.parseInt(maxLength) / 2);
                    }
                    dataType = dataType + "(" + ("-1".equals(maxLength) ? "MAX" : String.valueOf(maxLength)) + ")";
                }
                sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + this.quoted(columnName) + " " + dataType + " null", this.getDataSource());
            }
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Unable to disable not null constraints for schema name: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
    }

    protected Map<String, Set<String>> getTablePrimaryKeyColumnsMap(String schemaName) {
        HashMap<String, Set<String>> hashMap;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getDataSource().getConnection();
            statement = connection.createStatement();
            HashMap<String, Set<String>> tablePrimaryKeyColumnsMap = new HashMap<String, Set<String>>();
            resultSet = statement.executeQuery("select t.name table_name, c.name column_name from sys.key_constraints k, sys.index_columns i, sys.columns c, sys.tables t, sys.schemas s where k.type = 'PK' and i.index_id = k.unique_index_id and i.column_id = c.column_id   and c.object_id = t.object_id and k.parent_object_id = t.object_id and i.object_id = t.object_id  and t.schema_id = s.schema_id and s.name = '" + schemaName + "'");
            while (resultSet.next()) {
                String tableName = resultSet.getString("table_name");
                String columnName = resultSet.getString("column_name");
                HashSet<String> tablePrimaryKeyColumns = (HashSet<String>)tablePrimaryKeyColumnsMap.get(tableName);
                if (tablePrimaryKeyColumns == null) {
                    tablePrimaryKeyColumns = new HashSet<String>();
                    tablePrimaryKeyColumnsMap.put(tableName, tablePrimaryKeyColumns);
                }
                tablePrimaryKeyColumns.add(columnName);
            }
            hashMap = tablePrimaryKeyColumnsMap;
        }
        catch (Exception e) {
            try {
                throw new DatabaseException("Error while retrieving primary key column names for schema: " + schemaName, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return hashMap;
    }

    @Override
    public void setSettingIdentityColumnValueEnabled(String schemaName, String tableName, boolean enabled) {
        this.getSQLHandler().execute("SET IDENTITY_INSERT " + this.qualified(schemaName, tableName) + " " + (enabled ? "ON" : "OFF"), this.getDataSource());
    }

    @Override
    public boolean supportsSynonyms() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsRules() {
        return true;
    }

    @Override
    public boolean supportsIdentityColumns() {
        return true;
    }
}

