/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dbmaintain.database.DatabaseException;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseInfo {
    private String name;
    private String dialect;
    private String driverClassName;
    private String url;
    private String userName;
    private String password;
    private String defaultSchemaName;
    private Set<String> schemaNames;
    private boolean disabled;
    private boolean defaultDatabase;

    public DatabaseInfo(String name, String dialect, String driverClassName, String url, String userName, String password, List<String> schemaNames, boolean disabled, boolean defaultDatabase) {
        this.name = name;
        this.dialect = dialect;
        this.driverClassName = driverClassName;
        this.url = url;
        this.userName = userName;
        this.password = password == null ? "" : password;
        if (!schemaNames.isEmpty()) {
            this.defaultSchemaName = schemaNames.get(0);
        }
        this.schemaNames = new HashSet<String>(schemaNames);
        this.disabled = disabled;
        this.defaultDatabase = defaultDatabase;
    }

    public void validateFull() {
        if (StringUtils.isBlank(this.driverClassName)) {
            throw new DatabaseException(this.createValidationErrorMessage("no driver class name defined."));
        }
        if (StringUtils.isBlank(this.url)) {
            throw new DatabaseException(this.createValidationErrorMessage("no database url defined."));
        }
        if (StringUtils.isBlank(this.userName)) {
            throw new DatabaseException(this.createValidationErrorMessage("no database user name defined."));
        }
        this.validateMinimal();
    }

    public void validateMinimal() {
        if (this.schemaNames == null || this.schemaNames.isEmpty()) {
            throw new DatabaseException(this.createValidationErrorMessage("no schema name(s) defined."));
        }
    }

    private String createValidationErrorMessage(String reason) {
        if (StringUtils.isBlank(this.name)) {
            return "Invalid database configuration: " + reason;
        }
        return "Invalid database configuration for database with name " + this.name + ": " + reason;
    }

    public boolean hasName(String name) {
        if (this.name == null && name == null) {
            return true;
        }
        return this.name != null && this.name.equals(name);
    }

    public String getName() {
        return this.name;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public Set<String> getSchemaNames() {
        return this.schemaNames;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDefaultDatabase() {
        return this.defaultDatabase;
    }
}

