CREATE TABLE SH_CONVERSATION (
    "ID" number(19, 0),
    "TYPE" varchar2(255 char),
    "CREATE_DATE" timestamp(6),
    "TITLE" varchar2(1024 char),
    "LAST_MESSAGE_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_CONVERSATION_MESSAGE (
    "ID" number(19, 0),
    "CONVERSATION_ID" number(19, 0),
    "FROM_PERSON_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "MESSAGE" clob,
    "MESSAGE_TYPE" varchar2(32 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("ID")
);

CREATE TABLE SH_CONVERSATION_PARTICIPANT (
    "CONVERSATION_ID" number(19, 0),
    "PARTICIPANT_ID" number(19, 0),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "READ_DATE" timestamp(6),
    "DELETED" char(1 char),
    "LAST_MAIL_SENT" timestamp(6),
    "DELETED_WITH_CONVERSATION" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

CREATE TABLE SH_CONVERSATION_SETTINGS (
    "CONVERSATION_ID" number(19, 0),
    "PARTICIPANT_ID" number(19, 0),
    "MUTED" char(1 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    "HIDDEN" char(1 char),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("CONVERSATION_ID", "PARTICIPANT_ID")
);

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION','SH_CONVERSATION','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION_MESSAGE','SH_CONVERSATION_MESSAGE','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION_PARTICIPANT','SH_CONVERSATION_PARTICIPANT','f');
INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION_SETTINGS','SH_CONVERSATION_SETTINGS','f');

COMMIT;
