-- move old table
ALTER TABLE user_setting RENAME TO old_user_setting;

-- create new table
CREATE TABLE user_setting (
    person_id numeric(10,0) NOT NULL,
    key varchar2(30 CHAR) NOT NULL,
    value varchar2(4000 CHAR) NOT NULL,
    create_date timestamp DEFAULT systimestamp,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT user_setting__person_fk FOREIGN KEY (person_id) REFERENCES person (id) ON DELETE CASCADE,
    CONSTRAINT user_setting_pk PRIMARY KEY (person_id, key)
);

-- restore data to table
INSERT INTO user_setting (person_id, key, value, create_date, modify_date)
SELECT person_id, key, value, create_date, modify_date
FROM old_user_setting;

-- drop old table and sequence
DROP TABLE old_user_setting;
DROP SEQUENCE user_setting_seq;

------------------------ adjust shadow table ------------------------

-- move old shadow table
ALTER TABLE sh_user_setting RENAME TO old_sh_user_setting;

-- create new shadow table
CREATE TABLE sh_user_setting (
    "PERSON_ID" number(10, 0),
    "KEY" varchar2(30 char),
    "VALUE" varchar2(4000 char),
    "CREATE_DATE" timestamp(6),
    "MODIFY_DATE" timestamp(6),
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY("PERSON_ID", "KEY")
);

-- restore data to new shadow table
INSERT INTO sh_user_setting ("PERSON_ID", "KEY", "VALUE", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID)
SELECT "PERSON_ID", "KEY", "VALUE", "CREATE_DATE", "MODIFY_DATE", DELETE_ACTION_ID
FROM old_sh_user_setting;

-- drop old shadow table
DROP TABLE old_sh_user_setting;

COMMIT;
