ALTER TABLE tasks
MODIFY name varchar2(2048 CHAR);

ALTER TABLE tasks
MODIFY status varchar2(255 CHAR);

CREATE TABLE sh_tasks (
    id RAW(16),
    name varchar2(2048 CHAR),
    description clob,
    owner_id number(19),
    assignee_id number(19),
    status varchar2(255 CHAR),
    create_date timestamp,
    modify_date timestamp,
    parent_task_id RAW(16),
    delete_action_id number(19),
    CONSTRAINT sh_tasks_delete_action_id_fk FOREIGN KEY (delete_action_id) REFERENCES delete_action (id)
);

UPDATE tasks SET deleted = 't' WHERE parent_task_id IN (SELECT id FROM tasks WHERE deleted = 't');

INSERT INTO sh_tasks(id, name, description, owner_id, assignee_id, status, create_date, modify_date, parent_task_id)
SELECT               id, name, description, owner_id, assignee_id, status, create_date, modify_date, parent_task_id
FROM tasks
WHERE deleted = 't';

DELETE FROM tasks
WHERE deleted = 't';

ALTER TABLE tasks
DROP COLUMN deleted;

INSERT INTO shadow_table (table_name,shadow_table_name,delete_action_mandatory)
VALUES ('TASKS','SH_TASKS','f');

COMMIT;