-- remove table with different pk
DROP TABLE push_notification_device;

CREATE SEQUENCE push_notification_device_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

-- recreate tabel with new pk
CREATE TABLE push_notification_device (
    id NUMBER(19,0) NOT NULL,
    device_id VARCHAR2(256 char) NOT NULL,
    protocol VARCHAR2(100 char) NOT NULL,
    person_id NUMBER(19,0) NOT NULL,
    create_at timestamp DEFAULT systimestamp,
    modify_at timestamp DEFAULT systimestamp,
    CONSTRAINT p_n_device_pk PRIMARY KEY (id),
    CONSTRAINT p_n_device_uq UNIQUE (device_id, protocol),
    CONSTRAINT p_n_device_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE
);

-- access by person id is very common. make it faster:
CREATE INDEX p_n_device_person_idx ON push_notification_device(person_id);

COMMIT;
