CREATE SEQUENCE export_item_event_queue_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE export_item_event_queue (
    id number(19) NOT NULL,
    type varchar2(32 CHAR) NOT NULL,
    item_id number(19) NOT NULL,
    item_type varchar2(32 CHAR) NOT NULL,
    state varchar2(32 CHAR) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp NOT NULL,
    CONSTRAINT export_item_event_queue_pk PRIMARY KEY (id)
);

CREATE OR REPLACE TRIGGER export_item_event_queue_bri
BEFORE INSERT ON export_item_event_queue
REFERENCING NEW AS new
FOR EACH ROW
WHEN (new.id IS NULL)
BEGIN
    SELECT export_item_event_queue_seq.nextval
    INTO :new.id
    FROM dual;
END export_item_event_queue_bri;
/

COMMIT;
