
INSERT INTO version (id, release, name, type, description, "date")
VALUES (00007, '7.9', '00007_#patch_create_oauth_tables', 'FEATURE', '#8291 - OAuth: Token und Client Details in Datenbank speichern', now());

-- used in tests that use HSQL
create table oauth_client_details (
  client_id VARCHAR2(256 char) PRIMARY KEY,
  resource_ids VARCHAR2(256 char),
  client_secret VARCHAR2(256 char),
  scope VARCHAR2(256 char),
  authorized_grant_types VARCHAR2(256 char),
  web_server_redirect_uri VARCHAR2(256 char),
  authorities VARCHAR2(256 char),
  access_token_validity INTEGER,
  refresh_token_validity INTEGER,
  additional_information VARCHAR2(4000 char),
  autoapprove VARCHAR2(256 char)
);

create table oauth_client_token (
  token_id VARCHAR2(256 char),
  token BLOB,
  authentication_id VARCHAR2(256 char),
  user_name VARCHAR2(256 char),
  client_id VARCHAR2(256 char)
);

create table oauth_access_token (
  token_id VARCHAR2(256 char),
  token BLOB,
  authentication_id VARCHAR2(256 char),
  user_name VARCHAR2(256 char),
  client_id VARCHAR2(256 char),
  authentication BLOB,
  refresh_token VARCHAR2(256 char)
);

create table oauth_refresh_token (
  token_id VARCHAR2(256 char),
  token BLOB,
  authentication BLOB
);

create table oauth_code (
  code VARCHAR2(256 char), authentication BLOB
);

create table oauth_approvals (
  userId VARCHAR2(256 char),
  clientId VARCHAR2(256 char),
  scope VARCHAR2(256 char),
  status VARCHAR2(10 char),
  expiresAt TIMESTAMP,
  lastModifiedAt TIMESTAMP
);

insert into oauth_client_details (client_id, scope, authorities, authorized_grant_types)
values ('mobile', 'api', 'ROLE_USER', 'implicit,password,authorization_code,client_credentials');

COMMIT;
