INSERT INTO version (id, release, name, type, description, "date")
VALUES (00001, '7.5', '00001_#patch_item_visibility_entity_parents.sql', 'FEATURE', '#7229 Sichtbarkeit von Entitäten in der DB speichern', now());

CREATE TABLE entity_parents (
    entity_id NUMBER(19, 0) NOT NULL,
    parent_id NUMBER(19, 0) NOT NULL,
    created_at TIMESTAMP DEFAULT systimestamp,
    CONSTRAINT entity_parents_pk PRIMARY KEY (entity_id, parent_id),
    CONSTRAINT entity_parents_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE,
    CONSTRAINT entity_parents_parent_fk FOREIGN KEY (parent_id) REFERENCES entity(id) ON DELETE CASCADE
);

CREATE INDEX entity_parents_parent_idx on entity_parents(parent_id);

CREATE TABLE item_visibility_person (
  item_id NUMBER(19, 0) NOT NULL,
  item_type VARCHAR2(32 char) NOT NULL,
  person_id NUMBER(19, 0) NOT NULL,
  created_at TIMESTAMP DEFAULT systimestamp,
  CONSTRAINT itm_vis_pers_pk PRIMARY KEY (item_id, item_type, person_id),
  CONSTRAINT itm_vis_pers_pers_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE
);

CREATE INDEX itm_vis_pers_pers_idx ON item_visibility_person(person_id);

CREATE TABLE item_visibility_role (
  item_id NUMBER(19, 0) NOT NULL,
  item_type VARCHAR2(32 char) NOT NULL,
  role_name VARCHAR2(15 char) NOT NULL,
  created_at TIMESTAMP DEFAULT systimestamp,
  CONSTRAINT itm_vis_role_pk PRIMARY KEY (item_id, item_type, role_name),
  CONSTRAINT itm_vis_role_role_fk FOREIGN KEY (role_name) REFERENCES person_role(role_name) ON DELETE CASCADE
);

CREATE INDEX itm_vis_role_role_idx ON item_visibility_role(role_name);

COMMIT;
