INSERT INTO version (
  id, release, name, type, description, "date"
) VALUES (
  01319, '6.14', '01319_6.14_multiwiki_alter_section.sql', 'FEATURE', '#4452 Mehrere Editoren in dem Mehrfacheditoren-Modul umsetzen', now()
);

-- Add section_id and section_order to multi_wiki_version_section
ALTER TABLE multi_wiki_section RENAME TO multi_wiki_version_section;
RENAME multi_wiki_section_seq TO multi_wiki_version_section_seq;

CREATE SEQUENCE multi_wiki_section_seq
    START WITH 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

ALTER TABLE multi_wiki_version_section ADD section_id NUMBER(19) DEFAULT 0 NOT NULL;
ALTER TABLE multi_wiki_version_section ADD section_order NUMBER(9) DEFAULT 0 NOT NULL;
ALTER TABLE multi_wiki_version_section ADD UNIQUE(section_id, version_id);

-- The parent of an MultiWiki is always an entity
ALTER TABLE multi_wiki DROP CONSTRAINT multi_wiki_parent_unq;
ALTER TABLE multi_wiki RENAME COLUMN parent_item_id TO entity_id;
ALTER TABLE multi_wiki DROP COLUMN parent_item_type;
DELETE FROM multi_wiki WHERE entity_id not in (SELECT id FROM entity);
ALTER TABLE multi_wiki ADD FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE;
ALTER TABLE multi_wiki ADD CONSTRAINT multi_wiki_parent_unq UNIQUE(entity_id);
