
-- ORACLE --
INSERT INTO version (id, release, name, type, description, "date")
VALUES (0136, '6.13', '01316-create-entity-version-table', 'FEATURE', '#4425 Implementierung der Basis für den Freigabe-Workflow von Entitäten', now());

CREATE SEQUENCE entity_version_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE entity_version 
(
    id number(8) NOT NULL,
    entity_id number(8) NOT NULL,
    parent_version_id number(8),
    person_id number(8) NOT NULL,
    major_version integer DEFAULT 0,
    minor_version integer DEFAULT 0,
    draft_version integer DEFAULT 0,
    version_type varchar2(255 CHAR) NOT NULL, -- MAJOR/MINOR/EDITORIAL
    target_type varchar2(255 CHAR),
    version_status varchar2(255 CHAR) NOT NULL, -- PRIVATE/IN_REVIEW/PUBLIC/DECLINED
    release_date timestamp,
    expiration_date timestamp,
    change_message varchar2(255 CHAR),
    comment_for_reviewers varchar2(255 CHAR),
    CONSTRAINT entity_version_pk PRIMARY KEY (id),
    CONSTRAINT entity_version_version_uq UNIQUE (entity_id, major_version, minor_version, draft_version),
    CONSTRAINT entity_version_entity_id_fk FOREIGN KEY (entity_id)
      REFERENCES entity (id) 
      ON DELETE CASCADE,
    CONSTRAINT entity_version_person_id_fk FOREIGN KEY (person_id)
      REFERENCES person (id) 
      ON DELETE CASCADE
);

CREATE TABLE entity_version_review 
(
    entity_version_id number(8) NOT NULL,
    reviewer_id number(8) NOT NULL,
    inviter_id number(8) NOT NULL,
    review_status varchar2(255 CHAR) NOT NULL,
    review_order number(8) NOT NULL,
    CONSTRAINT entity_version_review_pk PRIMARY KEY (entity_version_id, reviewer_id), 
    CONSTRAINT entity_version_id_fk FOREIGN KEY (entity_version_id)
        REFERENCES entity_version (id) 
        ON DELETE CASCADE,
    CONSTRAINT entity_version_reviewer_fk FOREIGN KEY (reviewer_id)
        REFERENCES person (id) 
        ON DELETE CASCADE, 
    CONSTRAINT entity_version_inviter_fk FOREIGN KEY (inviter_id)
        REFERENCES person (id) 
        ON DELETE CASCADE, 
    CONSTRAINT entity_version_review_order_uq UNIQUE (entity_version_id, review_order)
);

COMMIT;
