/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.qualifier.impl;

import java.util.Set;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.qualifier.QualifierEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeExcludeQualifierEvaluator
implements QualifierEvaluator {
    public static final Qualifier UNQUALIFIED = new Qualifier("<unqualified>");
    private final Set<Qualifier> includedQualifiers;
    private final Set<Qualifier> excludedQualifiers;

    public IncludeExcludeQualifierEvaluator(Set<Qualifier> registeredQualifiers, Set<Qualifier> includedQualifiers, Set<Qualifier> excludedQualifiers) {
        this.includedQualifiers = includedQualifiers;
        this.excludedQualifiers = excludedQualifiers;
        this.ensureQualifiersRegistered(registeredQualifiers, includedQualifiers);
        this.ensureQualifiersRegistered(registeredQualifiers, excludedQualifiers);
    }

    @Override
    public boolean evaluate(Set<Qualifier> qualifiers) {
        return (this.includedQualifiers.isEmpty() || this.containsIncludedQualifier(qualifiers)) && !this.containsExcludedQualifier(qualifiers);
    }

    protected void ensureQualifiersRegistered(Set<Qualifier> registeredQualifiers, Set<Qualifier> qualifiers) {
        for (Qualifier qualifier : qualifiers) {
            if (UNQUALIFIED.equals(qualifier) || registeredQualifiers.contains(qualifier)) continue;
            throw new IllegalArgumentException(qualifier + " is not registered");
        }
    }

    protected boolean containsExcludedQualifier(Set<Qualifier> qualifiers) {
        if (qualifiers.isEmpty()) {
            return this.excludedQualifiers.contains(UNQUALIFIED);
        }
        for (Qualifier qualifier : qualifiers) {
            if (!this.excludedQualifiers.contains(qualifier)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsIncludedQualifier(Set<Qualifier> qualifiers) {
        if (qualifiers.isEmpty()) {
            return this.includedQualifiers.contains(UNQUALIFIED);
        }
        for (Qualifier qualifier : qualifiers) {
            if (!this.includedQualifiers.contains(qualifier)) continue;
            return true;
        }
        return false;
    }
}

