/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.archive;

import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.config.FactoryWithoutDatabase;
import org.dbmaintain.config.PropertyUtils;
import org.dbmaintain.script.archive.ScriptArchiveCreator;
import org.dbmaintain.script.archive.impl.DefaultScriptArchiveCreator;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.repository.ScriptRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptArchiveCreatorFactory
extends FactoryWithoutDatabase<ScriptArchiveCreator> {
    @Override
    public ScriptArchiveCreator createInstance() {
        ScriptRepository scriptRepository = this.factoryContext.createScriptRepository();
        String scriptEncoding = PropertyUtils.getString("dbMaintainer.script.encoding", this.getConfiguration());
        String postProcessingScriptDirName = PropertyUtils.getString("dbMaintainer.postProcessingScript.directoryName", this.getConfiguration());
        Set<Qualifier> registeredQualifiers = this.factoryContext.createQualifiers(PropertyUtils.getStringList("dbMaintainer.qualifiers", this.getConfiguration()));
        Set<Qualifier> patchQualifiers = this.factoryContext.createQualifiers(PropertyUtils.getStringList("dbMaintainer.script.patch.qualifiers", this.getConfiguration()));
        String scriptIndexRegexp = PropertyUtils.getString("dbMaintainer.script.index.regexp", this.getConfiguration());
        String qualifierRegexp = PropertyUtils.getString("dbMaintainer.script.qualifier.regexp", this.getConfiguration());
        String targetDatabaseRegexp = PropertyUtils.getString("dbMaintainer.script.targetDatabase.regexp", this.getConfiguration());
        HashSet<String> scriptFileExtensions = new HashSet<String>(PropertyUtils.getStringList("dbMaintainer.script.fileExtensions", this.getConfiguration()));
        ScriptIndexes baselineRevision = this.factoryContext.getBaselineRevision();
        boolean ignoreCarriageReturnsWhenCalculatingCheckSum = PropertyUtils.getBoolean("dbMaintainer.script.ignoreCarriageReturnsWhenCalculatingCheckSum", this.getConfiguration());
        return new DefaultScriptArchiveCreator(scriptRepository, scriptEncoding, postProcessingScriptDirName, registeredQualifiers, patchQualifiers, scriptIndexRegexp, qualifierRegexp, targetDatabaseRegexp, scriptFileExtensions, baselineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
    }
}

