/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.analyzer;

import java.util.SortedSet;
import org.dbmaintain.script.analyzer.ScriptUpdate;
import org.dbmaintain.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUpdates {
    private SortedSet<ScriptUpdate> regularlyAddedOrModifiedScripts;
    private SortedSet<ScriptUpdate> irregularScriptUpdates;
    private SortedSet<ScriptUpdate> regularlyDeletedRepeatableScripts;
    private SortedSet<ScriptUpdate> regularlyAddedPatchScripts;
    private SortedSet<ScriptUpdate> regularPostprocessingScriptUpdates;
    private SortedSet<ScriptUpdate> regularlyRenamedScripts;

    protected ScriptUpdates(SortedSet<ScriptUpdate> regularlyAddedOrModifiedScripts, SortedSet<ScriptUpdate> irregularScriptUpdates, SortedSet<ScriptUpdate> regularlyDeletedRepeatableScripts, SortedSet<ScriptUpdate> regularlyAddedPatchScripts, SortedSet<ScriptUpdate> regularPostprocessingScriptUpdates, SortedSet<ScriptUpdate> regularlyRenamedScripts) {
        this.regularlyAddedOrModifiedScripts = regularlyAddedOrModifiedScripts;
        this.irregularScriptUpdates = irregularScriptUpdates;
        this.regularlyDeletedRepeatableScripts = regularlyDeletedRepeatableScripts;
        this.regularlyAddedPatchScripts = regularlyAddedPatchScripts;
        this.regularPostprocessingScriptUpdates = regularPostprocessingScriptUpdates;
        this.regularlyRenamedScripts = regularlyRenamedScripts;
    }

    public SortedSet<ScriptUpdate> getRegularlyAddedOrModifiedScripts() {
        return this.regularlyAddedOrModifiedScripts;
    }

    public SortedSet<ScriptUpdate> getIrregularScriptUpdates() {
        return this.irregularScriptUpdates;
    }

    public SortedSet<ScriptUpdate> getRegularlyDeletedRepeatableScripts() {
        return this.regularlyDeletedRepeatableScripts;
    }

    public SortedSet<ScriptUpdate> getRegularlyAddedPatchScripts() {
        return this.regularlyAddedPatchScripts;
    }

    public SortedSet<ScriptUpdate> getRegularlyRenamedScripts() {
        return this.regularlyRenamedScripts;
    }

    public SortedSet<ScriptUpdate> getRegularPostprocessingScriptUpdates() {
        return this.regularPostprocessingScriptUpdates;
    }

    public SortedSet<ScriptUpdate> getRegularScriptUpdates() {
        return CollectionUtils.unionSortedSet(this.regularlyAddedOrModifiedScripts, this.regularlyAddedPatchScripts, this.regularlyRenamedScripts, this.regularlyDeletedRepeatableScripts, this.regularPostprocessingScriptUpdates);
    }

    public boolean hasIrregularScriptUpdates() {
        return this.irregularScriptUpdates.size() > 0;
    }

    public boolean noUpdatesOtherThanRepeatableScriptDeletionsOrRenames() {
        return this.regularlyAddedOrModifiedScripts.size() == 0 && this.irregularScriptUpdates.size() == 0 && this.regularlyAddedPatchScripts.size() == 0 && this.regularPostprocessingScriptUpdates.size() == 0;
    }

    public boolean isEmpty() {
        return this.regularlyAddedOrModifiedScripts.size() == 0 && this.irregularScriptUpdates.size() == 0 && this.regularlyAddedPatchScripts.size() == 0 && this.regularPostprocessingScriptUpdates.size() == 0 && this.regularlyRenamedScripts.size() == 0 && this.regularlyDeletedRepeatableScripts.size() == 0;
    }

    public String toString() {
        return "ScriptUpdates{" + (!this.regularlyAddedOrModifiedScripts.isEmpty() ? "regularlyAddedOrModifiedScripts=" + this.regularlyAddedOrModifiedScripts : "") + (!this.irregularScriptUpdates.isEmpty() ? ", irregularScriptUpdates=" + this.irregularScriptUpdates : "") + (!this.regularlyDeletedRepeatableScripts.isEmpty() ? ", regularlyDeletedRepeatableScripts=" + this.regularlyDeletedRepeatableScripts : "") + (!this.regularlyAddedPatchScripts.isEmpty() ? ", regularlyAddedPatchScripts=" + this.regularlyAddedPatchScripts : "") + (!this.regularPostprocessingScriptUpdates.isEmpty() ? ", regularPostprocessingScriptUpdates=" + this.regularPostprocessingScriptUpdates : "") + (!this.regularlyRenamedScripts.isEmpty() ? ", regularlyRenamedScripts=" + this.regularlyRenamedScripts : "") + '}';
    }
}

