/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.launch.commandline;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.dbmaintain.MainFactory;
import org.dbmaintain.config.DbMaintainConfigurationLoader;
import org.dbmaintain.launch.commandline.CommandLineArguments;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.FileUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

public class CommandLine {
    public static final String DBMAINTAIN_PROPERTIES = "dbmaintain.properties";
    private static Log logger = LogFactory.getLog(CommandLine.class);

    public static void main(String[] args) {
        CommandLineArguments commandLineArguments = CommandLine.parseCommandLineArguments(args);
        Properties configuration = CommandLine.loadConfiguration(commandLineArguments);
        DbMaintainOperation operation = CommandLine.getDbMaintainOperation(commandLineArguments);
        CommandLine.executeOperation(operation, configuration, commandLineArguments);
    }

    protected static CommandLineArguments parseCommandLineArguments(String[] args) {
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(args);
        }
        catch (DbMaintainException e) {
            System.err.println("\n" + e.getMessage());
            CommandLine.printHelpMessage();
            System.exit(1);
        }
        return commandLineArguments;
    }

    protected static DbMaintainOperation getDbMaintainOperation(CommandLineArguments commandLineArguments) {
        String dbMaintainOperation = commandLineArguments.getDbMaintainOperation();
        DbMaintainOperation operation = DbMaintainOperation.getByOperationName(dbMaintainOperation);
        if (operation == null) {
            System.err.println("Invalid operation " + dbMaintainOperation);
            CommandLine.printHelpMessage();
            System.exit(1);
        }
        return operation;
    }

    protected static Properties loadConfiguration(CommandLineArguments commandLineArguments) {
        URL propertiesAsURL = null;
        String customConfigFile = commandLineArguments.getConfigFile();
        if (customConfigFile == null) {
            if (new File(DBMAINTAIN_PROPERTIES).exists()) {
                propertiesAsURL = CommandLine.getPropertiesAsURL(DBMAINTAIN_PROPERTIES);
                logger.info("Loaded configuration from file dbmaintain.properties");
            }
        } else {
            propertiesAsURL = CommandLine.getPropertiesAsURL(customConfigFile);
            logger.info("Loaded configuration from file " + customConfigFile);
        }
        return new DbMaintainConfigurationLoader().loadConfiguration(propertiesAsURL);
    }

    public static void executeOperation(DbMaintainOperation operation, Properties configuration, CommandLineArguments commandLineArguments) {
        switch (operation) {
            case CREATE_SCRIPT_ARCHIVE: {
                if (commandLineArguments.getFirstExtraArgument() == null) {
                    System.err.println("Archive file name must be specified as extra argument");
                    System.exit(1);
                }
                if (commandLineArguments.getSecondExtraArgument() != null) {
                    configuration.put("dbMaintainer.script.locations", commandLineArguments.getSecondExtraArgument());
                }
                String jarFileName = commandLineArguments.getFirstExtraArgument();
                CommandLine.getMainFactory(configuration).createScriptArchiveCreator().createScriptArchive(jarFileName);
                break;
            }
            case CHECK_SCRIPT_UPDATES: {
                if (commandLineArguments.getFirstExtraArgument() != null) {
                    configuration.put("dbMaintainer.script.locations", commandLineArguments.getFirstExtraArgument());
                }
                CommandLine.getMainFactory(configuration).createDbMaintainer().updateDatabase(true);
                break;
            }
            case UPDATE_DATABASE: {
                if (commandLineArguments.getFirstExtraArgument() != null) {
                    configuration.put("dbMaintainer.script.locations", commandLineArguments.getFirstExtraArgument());
                }
                CommandLine.getMainFactory(configuration).createDbMaintainer().updateDatabase(false);
                break;
            }
            case MARK_DATABASE_AS_UPTODATE: {
                if (commandLineArguments.getFirstExtraArgument() != null) {
                    configuration.put("dbMaintainer.script.locations", commandLineArguments.getFirstExtraArgument());
                }
                CommandLine.getMainFactory(configuration).createDbMaintainer().markDatabaseAsUpToDate();
                break;
            }
            case MARK_ERROR_SCRIPT_PERFORMED: {
                CommandLine.getMainFactory(configuration).createExecutedScriptInfoSource().markErrorScriptsAsSuccessful();
                break;
            }
            case MARK_ERROR_SCRIPT_REVERTED: {
                CommandLine.getMainFactory(configuration).createExecutedScriptInfoSource().removeErrorScripts();
                break;
            }
            case CLEAR_DATABASE: {
                CommandLine.getMainFactory(configuration).createDBClearer().clearDatabase();
                break;
            }
            case CLEAN_DATABASE: {
                CommandLine.getMainFactory(configuration).createDBCleaner().cleanDatabase();
                break;
            }
            case DISABLE_CONSTRAINTS: {
                CommandLine.getMainFactory(configuration).createConstraintsDisabler().disableConstraints();
                break;
            }
            case UPDATE_SEQUENCES: {
                CommandLine.getMainFactory(configuration).createSequenceUpdater().updateSequences();
            }
        }
    }

    protected static MainFactory getMainFactory(Properties configuration) {
        return new MainFactory(configuration);
    }

    protected static URL getPropertiesAsURL(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            System.err.println("Could not find config filedbmaintain.properties");
            System.exit(1);
        }
        return FileUtils.getUrl(file);
    }

    public static void printHelpMessage() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println();
        System.out.println("java org.dbmaintain.launch.DbMaintain <operation> [extra operation arguments] [-config propertiesFile]");
        System.out.println();
        System.out.println("The -config argument is optional. If omitted, the file dbmaintain.properties is expected to be available in the execution directory.");
        System.out.println("The archive file/script folder argument is also optional, and only applicable to the operations " + DbMaintainOperation.CREATE_SCRIPT_ARCHIVE.getOperationName() + ", " + DbMaintainOperation.UPDATE_DATABASE.getOperationName() + " and " + DbMaintainOperation.MARK_DATABASE_AS_UPTODATE.getOperationName());
        System.out.println();
        System.out.println("Available operations are:");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.CREATE_SCRIPT_ARCHIVE.getOperationName());
        System.out.println("     Creates an archive file containing all scripts in all configured script locations.");
        System.out.println("     Expects a second argument indicating the file name.");
        System.out.println("     Optionally, a third argument may be added indicating the scripts archive file or root folder.");
        System.out.println("     This argument overrides the value of the property dbMaintainer.script.locations.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.UPDATE_DATABASE.getOperationName());
        System.out.println("     Updates the database to the latest version.");
        System.out.println("     Optionally, an extra argument may be added indicating the scripts archive file or root folder.");
        System.out.println("     This argument overrides the value of the property dbMaintainer.script.locations.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.MARK_ERROR_SCRIPT_PERFORMED.getOperationName());
        System.out.println("     Task that indicates that the failed script was manually performed.");
        System.out.println("     The script will NOT be run again in the next update.");
        System.out.println("     No scripts will be executed by this task.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.MARK_ERROR_SCRIPT_REVERTED.getOperationName());
        System.out.println("     Task that indicates that the failed script was manually reverted.");
        System.out.println("     The script will be run again in the next update.");
        System.out.println("     No scripts will be executed by this task.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.MARK_DATABASE_AS_UPTODATE.getOperationName());
        System.out.println("     Marks the database as up-to-date, without executing any script.");
        System.out.println("     You can use this operation to prepare an existing database to be managed by DbMaintain, ");
        System.out.println("     or after fixing a problem manually.");
        System.out.println("     Optionally, an extra argument may be added indicating the scripts archive file or root folder.");
        System.out.println("     This argument overrides the value of the property dbMaintainer.script.locations.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.CHECK_SCRIPT_UPDATES.getOperationName());
        System.out.println("     Checks if there are any script updates and prints them out, without executing any script.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.CLEAR_DATABASE.getOperationName());
        System.out.println("     Removes all database items, and empties the DBMAINTAIN_SCRIPTS table.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.CLEAN_DATABASE.getOperationName());
        System.out.println("     Removes the data of all database tables, except for the DBMAINTAIN_SCRIPTS table.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.DISABLE_CONSTRAINTS.getOperationName());
        System.out.println("     Disables or drops all foreign key and not null constraints.");
        System.out.println();
        System.out.println("- " + DbMaintainOperation.UPDATE_SEQUENCES.getOperationName());
        System.out.println("     Updates all sequences and identity columns to a minimal value.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DbMaintainOperation {
        CREATE_SCRIPT_ARCHIVE("createScriptArchive"),
        CHECK_SCRIPT_UPDATES("checkScriptUpdates"),
        UPDATE_DATABASE("updateDatabase"),
        MARK_ERROR_SCRIPT_PERFORMED("markErrorScriptPerformed"),
        MARK_ERROR_SCRIPT_REVERTED("markErrorScriptReverted"),
        MARK_DATABASE_AS_UPTODATE("markDatabaseAsUpToDate"),
        CLEAR_DATABASE("clearDatabase"),
        CLEAN_DATABASE("cleanDatabase"),
        DISABLE_CONSTRAINTS("disableConstraints"),
        UPDATE_SEQUENCES("updateSequences");

        private String operationName;

        private DbMaintainOperation(String operationName) {
            this.operationName = operationName;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public static DbMaintainOperation getByOperationName(String operationName) {
            for (DbMaintainOperation operation : DbMaintainOperation.values()) {
                if (!operation.getOperationName().equalsIgnoreCase(operationName)) continue;
                return operation;
            }
            return null;
        }
    }
}

