/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseConnectionManager;
import org.dbmaintain.database.DatabaseException;
import org.dbmaintain.database.DatabaseInfo;
import org.dbmaintain.database.DatabaseInfoFactory;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.datasource.DataSourceFactory;
import org.dbmaintain.util.DbMaintainException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseConnectionManager
implements DatabaseConnectionManager {
    protected List<DatabaseInfo> databaseInfos;
    protected SQLHandler sqlHandler;
    protected DatabaseInfoFactory databaseInfoFactory;
    protected DataSourceFactory dataSourceFactory;
    protected Map<String, DataSource> dataSourcesPerDatabaseName;
    protected Map<String, DatabaseConnection> databaseConnectionsPerDatabaseName = new HashMap<String, DatabaseConnection>();

    public DefaultDatabaseConnectionManager(Properties configuration, SQLHandler sqlHandler, DataSourceFactory dataSourceFactory) {
        this(configuration, sqlHandler, dataSourceFactory, new HashMap<String, DataSource>());
    }

    public DefaultDatabaseConnectionManager(Properties configuration, SQLHandler sqlHandler, DataSourceFactory dataSourceFactory, Map<String, DataSource> dataSourcesPerDatabaseName) {
        this.sqlHandler = sqlHandler;
        this.databaseInfoFactory = this.createDatabaseInfoFactory(configuration);
        this.dataSourceFactory = dataSourceFactory;
        this.dataSourcesPerDatabaseName = dataSourcesPerDatabaseName;
    }

    @Override
    public SQLHandler getSqlHandler() {
        return this.sqlHandler;
    }

    @Override
    public DatabaseConnection getDatabaseConnection(String databaseName) {
        DatabaseConnection databaseConnection = this.databaseConnectionsPerDatabaseName.get(databaseName);
        if (databaseConnection == null) {
            databaseConnection = this.createDatabaseConnection(databaseName);
            this.databaseConnectionsPerDatabaseName.put(databaseName, databaseConnection);
        }
        return databaseConnection;
    }

    @Override
    public List<DatabaseConnection> getDatabaseConnections() {
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseInfo databaseInfo : this.getDatabaseInfos()) {
            DatabaseConnection databaseConnection = this.getDatabaseConnection(databaseInfo.getName());
            result.add(databaseConnection);
        }
        return result;
    }

    protected DatabaseConnection createDatabaseConnection(String databaseName) {
        DatabaseInfo databaseInfo = this.getDatabaseInfo(databaseName);
        DataSource dataSource = null;
        if ((!databaseInfo.isDisabled() || databaseInfo.isDefaultDatabase()) && (dataSource = this.dataSourcesPerDatabaseName.get(databaseName)) == null) {
            dataSource = this.dataSourceFactory.createDataSource(databaseInfo);
        }
        return new DatabaseConnection(databaseInfo, this.sqlHandler, dataSource);
    }

    protected DatabaseInfo getDatabaseInfo(String databaseName) {
        for (DatabaseInfo databaseInfo : this.getDatabaseInfos()) {
            if (!databaseInfo.hasName(databaseName)) continue;
            databaseInfo.validateMinimal();
            return databaseInfo;
        }
        throw new DatabaseException("No database configuration found for " + (databaseName == null ? "default database" : "database with name " + databaseName) + ".");
    }

    protected List<DatabaseInfo> getDatabaseInfos() {
        if (this.databaseInfos == null) {
            this.databaseInfos = this.databaseInfoFactory.createDatabaseInfos();
            if (this.databaseInfos == null || this.databaseInfos.isEmpty()) {
                throw new DbMaintainException("No database configuration found. At least one database should be defined in the properties or in the task configuration.");
            }
        }
        return this.databaseInfos;
    }

    protected DatabaseInfoFactory createDatabaseInfoFactory(Properties configuration) {
        return new DatabaseInfoFactory(configuration);
    }
}

