/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class SubjectAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectAltName;
    private ArrayList<GeneralName> subjAltName = new ArrayList();

    public SubjectAltNameExtension() {
        super(TYPE);
    }

    public SubjectAltNameExtension(GeneralName subjAltName) {
        this(subjAltName, false);
    }

    public SubjectAltNameExtension(GeneralName subjAltName, boolean critical) {
        super(TYPE, critical);
        this.subjAltName.add(subjAltName);
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(Vector<GeneralName> subjAltName) {
        this((List<GeneralName>)subjAltName);
    }

    public SubjectAltNameExtension(List<GeneralName> subjAltName) {
        this(subjAltName, false);
    }

    public SubjectAltNameExtension(Vector<GeneralName> subjAltName, boolean critical) {
        this((List<GeneralName>)subjAltName, critical);
    }

    public SubjectAltNameExtension(List<GeneralName> subjAltName, boolean critical) {
        super(TYPE, critical);
        this.subjAltName = subjAltName == null ? null : (subjAltName instanceof ArrayList ? (ArrayList<Object>)subjAltName : new ArrayList<GeneralName>(subjAltName));
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(InputStream is) throws IOException {
        super(is);
    }

    public Enumeration<GeneralName> subjectAltName() {
        ArrayList<GeneralName> l = this.getSubjectAltName();
        return l == null ? null : new VectorOverArrayList(l).elements();
    }

    public ArrayList<GeneralName> getSubjectAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.subjAltName;
    }

    public void addSubjectAltName(GeneralName name) {
        this.subjAltName.add(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] b = Utils.toBytes((Streamable)new ASN1Sequence(this.subjAltName));
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            this.subjAltName = new ArrayList();
            while (sis.hasMoreData()) {
                this.subjAltName.add(new GeneralName((InputStream)sis));
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("subjectAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.subjAltName != null) {
            s.append("subjectAltNames = {");
            boolean mid = false;
            int size = this.subjAltName.size();
            for (int i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.subjAltName.get(i).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

