/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.connect.api.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class EntityVersionInfo {
    private final EntityVersionId _id;
    private final String _version;
    private final PersonId _authorId;
    private final String _changeMessage;
    private final String _status;
    private final EntityVersionType _type;
    private final DateTime _releaseDate;
    private final DateTime _expirationDate;
    private final ImmutableSet<EntityVersionComponent> _changedComponents;

    public EntityVersionInfo(EntityVersionId id, String version, PersonId authorId, @Nullable String changeMessage, String status, EntityVersionType type, @Nullable DateTime releaseDate, @Nullable DateTime expirationDate, ImmutableSet<EntityVersionComponent> changedComponents) {
        this._id = id;
        this._version = version;
        this._authorId = authorId;
        this._changeMessage = changeMessage;
        this._status = status;
        this._type = type;
        this._releaseDate = releaseDate;
        this._expirationDate = expirationDate;
        this._changedComponents = changedComponents;
    }

    @Nonnull
    public EntityVersionId getId() {
        return this._id;
    }

    @Nonnull
    public String getVersion() {
        return this._version;
    }

    @Nonnull
    public PersonId getAuthorId() {
        return this._authorId;
    }

    @CheckForNull
    public String getChangeMessage() {
        return this._changeMessage;
    }

    @Nonnull
    public String getStatus() {
        return this._status;
    }

    @Nonnull
    public EntityVersionType getType() {
        return this._type;
    }

    @CheckForNull
    public DateTime getReleaseDate() {
        return this._releaseDate;
    }

    @CheckForNull
    public DateTime getExpirationDate() {
        return this._expirationDate;
    }

    @Nonnull
    public ImmutableSet<EntityVersionComponent> getChangedComponents() {
        return this._changedComponents;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this._id).add("version", (Object)this._version).add("authorId", (Object)this._authorId).add("changeMessage", (Object)this._changeMessage).add("status", (Object)this._status).add("type", (Object)this._type).add("releaseDate", (Object)this._releaseDate).add("expirationDate", (Object)this._expirationDate).add("changedComponents", this._changedComponents).toString();
    }

    @ParametersAreNonnullByDefault
    public static enum EntityVersionComponent {
        FILES,
        CONTENT;

    }
}

