/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.app.connect.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MyContentEntity;
import de.justsoftware.onx.like.shared.model.SubscriptionState;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntitySubscriptionModel {
    private final ItemId _itemId;
    private final String _name;
    private final SubscriptionState _subscriptionState;
    private final ImmutableSet<Action> _permissions;

    @JsonCreator
    public EntitySubscriptionModel(@JsonProperty(value="itemId", required=true) ItemId itemId, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="subscriptionState", required=true) SubscriptionState subscriptionState, @JsonProperty(value="permissions", required=true) ImmutableSet<Action> permissions) {
        this._itemId = itemId;
        this._name = name;
        this._subscriptionState = subscriptionState;
        this._permissions = permissions;
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public SubscriptionState getSubscriptionState() {
        return this._subscriptionState;
    }

    @Nonnull
    public ImmutableSet<Action> getPermissions() {
        return this._permissions;
    }

    @Nonnull
    public static EntitySubscriptionModel from(MyContentEntity contentEntity, ImmutableSet<Action> permissions) {
        return new EntitySubscriptionModel((ItemId)contentEntity.getId(), contentEntity.getName(), contentEntity.getSubscriptionState(), permissions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("itemId", (Object)this._itemId).add("name", (Object)this._name).add("subscriptionState", (Object)this._subscriptionState).add("permissions", this._permissions).toString();
    }
}

