/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.util.HtmlUtils;

@ParametersAreNonnullByDefault
public class JustContext {
    private final String _locale;
    private final ImmutableList<UserAppConfig> _availableApps;
    private final ImmutableList<ImmutableList<AppId>> _homeScreenApps;
    private final PersonId _userId;
    private final ImmutableMap<String, Boolean> _toggles;
    private final TenantId _tenantId;
    private final String _tenantName;
    private final String _currentVersion;
    private final boolean _powerBarEnabled;
    private final int _pollingIntervalInSeconds;

    public JustContext(String locale, PersonId userId, ImmutableList<UserAppConfig> availableApps, ImmutableList<ImmutableList<AppId>> homeScreenApps, String currentVersion, @Nullable TenantId tenantId, @Nullable String tenantName, ImmutableMap<String, Boolean> toggles, boolean powerBarEnabled, int pollingIntervalInSeconds) {
        this._locale = locale;
        this._availableApps = availableApps;
        this._homeScreenApps = homeScreenApps;
        this._userId = userId;
        this._currentVersion = currentVersion;
        this._tenantId = tenantId;
        this._tenantName = tenantName != null ? HtmlUtils.htmlEscape((String)tenantName, (String)"UTF-8") : null;
        this._toggles = toggles;
        this._powerBarEnabled = powerBarEnabled;
        this._pollingIntervalInSeconds = pollingIntervalInSeconds;
    }

    @Nonnull
    public String getLocale() {
        return this._locale;
    }

    @Nonnull
    public ImmutableList<UserAppConfig> getAvailableApps() {
        return this._availableApps;
    }

    @Nonnull
    public ImmutableList<ImmutableList<AppId>> getHomeScreenApps() {
        return this._homeScreenApps;
    }

    @Nonnull
    public PersonId getUserId() {
        return this._userId;
    }

    @Nonnull
    public ImmutableMap<String, Boolean> getToggles() {
        return this._toggles;
    }

    @Nonnull
    public String getCurrentVersion() {
        return this._currentVersion;
    }

    @CheckForNull
    public TenantId getTenantId() {
        return this._tenantId;
    }

    @CheckForNull
    public String getTenantName() {
        return this._tenantName;
    }

    public boolean isPowerBarEnabled() {
        return this._powerBarEnabled;
    }

    public int getPollingIntervalInSeconds() {
        return this._pollingIntervalInSeconds;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("locale", (Object)this._locale).add("availableApps", this._availableApps).add("homeScreenApps", this._homeScreenApps).add("userId", (Object)this._userId).add("currentVersion", (Object)this._currentVersion).add("tenantId", (Object)this._tenantId).add("tenantName", (Object)this._tenantName).add("toggles", this._toggles).add("powerBarEnabled", this._powerBarEnabled).add("pollingIntervalInSeconds", this._pollingIntervalInSeconds).toString();
    }
}

