/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller.support;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.context.api.model.JustContextError;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackages={"de.justsoftware.context"})
@ParametersAreNonnullByDefault
public class JustContextExceptionHandlingControllerAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(JustContextExceptionHandlingControllerAdvice.class);

    @ExceptionHandler(value={PermissionDeniedException.class})
    @Nonnull
    public ResponseEntity<JustContextError> handlePermissionDeniedException(PermissionDeniedException e) {
        LOG.debug("permission denied", (Throwable)e);
        return this.createJustContextError((Throwable)e, HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={NotLoggedInException.class})
    @Nonnull
    public ResponseEntity<JustContextError> handleNotLoggedInException(NotLoggedInException e) {
        LOG.debug("unauthorized", (Throwable)e);
        return this.createJustContextError((Throwable)e, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @Nonnull
    public ResponseEntity<JustContextError> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        LOG.error("invalid http message", (Throwable)e);
        return this.createJustContextError((Throwable)e, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InvalidIdServiceException.class})
    @Nonnull
    public ResponseEntity<JustContextError> handleInvalidIdServiceException(InvalidIdServiceException e) {
        LOG.error("invalid ID", (Throwable)e);
        return this.createJustContextError((Throwable)e, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={Throwable.class})
    @Nonnull
    public ResponseEntity<JustContextError> handleThrowable(Throwable t) {
        LOG.error("some unexpected error happened: ", t);
        return this.createJustContextError(t, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Nonnull
    private ResponseEntity<JustContextError> createJustContextError(Throwable t, HttpStatus status) {
        return new ResponseEntity((Object)new JustContextError(t.getClass().getSimpleName() + ": " + t.getMessage()), status);
    }
}

