/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import de.justsoftware.context.api.business.ContextThemeService;
import de.justsoftware.context.api.model.ContextTheme;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.design.shared.model.ThemeId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="JustContextThemeController")
@ParametersAreNonnullByDefault
@RequestMapping(path={"/context/api/v1/theme"})
@Api(tags={"Theme"})
public class ThemeController {
    private final ContextThemeService _themeService;

    @Autowired
    public ThemeController(ContextThemeService themeService) {
        this._themeService = themeService;
    }

    @RequestMapping(value={"/{themeId}"}, method={RequestMethod.GET})
    @ApiOperation(value="Get theme with the given themeId. If no tenantId is defined, we will use the default tenantId of the current user.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - context is returned"), @ApiResponse(code=404, message="theme not found"), @ApiResponse(code=500, message="fatal error - some internal error")})
    @Nonnull
    public ContextTheme getTheme(@PathVariable(value="themeId") ThemeId themeId, @AuthorizedContext AuthorizationContext authContext) {
        return (ContextTheme)InvalidIdServiceException.check((Object)this._themeService.getThemeById(themeId, authContext));
    }

    @RequestMapping(value={"/tenant-theme"}, method={RequestMethod.GET})
    @ApiOperation(value="Get theme with the given tenant id.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - context is returned"), @ApiResponse(code=404, message="theme not found"), @ApiResponse(code=500, message="fatal error - some internal error")})
    @Nonnull
    public ContextTheme getTenantTheme(@AuthorizedContext AuthorizationContext authContext) {
        return (ContextTheme)InvalidIdServiceException.check((Object)this._themeService.getTheme(authContext));
    }
}

