/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller;

import com.freiheit.toro.common.shared.model.NotLoggedInException;
import com.google.common.collect.ImmutableList;
import de.justsoftware.context.api.business.HomeScreenService;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/context/api/v1/homeScreen"})
@Api(tags={"Home Screen"})
public class HomeScreenController {
    private final HomeScreenService _homeScreenService;

    @Autowired
    public HomeScreenController(HomeScreenService homeScreenService) {
        this._homeScreenService = homeScreenService;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/homeScreenApps"})
    @ApiOperation(value="Get the apps the current user has placed on their home screen", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - the home screen apps have been returned"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error occurred")})
    @Nonnull
    public ImmutableList<ImmutableList<AppId>> getHomeScreenApps(@AuthorizedContext AuthorizationContext authContext) {
        this.checkAuthenticated(authContext);
        return this._homeScreenService.getHomeScreenApps(authContext);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/homeScreenApps"})
    @ApiOperation(value="Updates the apps the current user placed on their home screen", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - the home screen apps have been updated"), @ApiResponse(code=403, message="not authorized"), @ApiResponse(code=500, message="fatal error - some internal error occurred")})
    @Nonnull
    public ImmutableList<ImmutableList<AppId>> setHomeScreenApps(@RequestBody ImmutableList<ImmutableList<AppId>> homeScreenApps, @AuthorizedContext AuthorizationContext authContext) {
        this.checkAuthenticated(authContext);
        this._homeScreenService.setHomeScreenApps(authContext, homeScreenApps);
        return this._homeScreenService.getHomeScreenApps(authContext);
    }

    private void checkAuthenticated(AuthorizationContext authContext) {
        PersonId personId = authContext.getUserId();
        if (personId == null) {
            throw new NotLoggedInException("User must be authenticated to access this API.");
        }
    }
}

