/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.controller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.common.AuthorizedContext;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.permission.client.model.Role;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(path={"/context/api/v1/appConfig"})
@Api(tags={"App Configurations"})
public class AppConfigController {
    private final AppConfigService _appConfigService;

    @Autowired
    public AppConfigController(AppConfigService appConfigService) {
        this._appConfigService = appConfigService;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/apps"})
    @ApiOperation(value="Get all app configurations. This is the system wide configuration, only accessible by system administrators.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - app configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableList<AppConfig> getAppConfigs(@AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        return this._appConfigService.getAllAppConfigs();
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/apps"})
    @ApiOperation(value="Set the app configurations and return the new app configurations", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - app configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableList<AppConfig> setAppConfigs(@RequestBody ImmutableList<AppConfig> newAppConfigs, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this._appConfigService.setAllAppConfigs(newAppConfigs);
        return this._appConfigService.getAllAppConfigs();
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/visibilities"})
    @ApiOperation(value="Get the app initial visibility configurations for the given tenantId.\nIf no tenantId is defined, we will return the tenant independent app initial visibility configurations.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - app visibility configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableTable<Role, AppId, InitialVisibility> getInitialAppVisibilityConfigurations(@RequestParam(value="tenantId", required=false) @Nullable TenantId tenantId, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        return this._appConfigService.getInitialAppVisibilityConfigsByTenant(tenantId);
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/visibilities"})
    @ApiOperation(value="Set the app initial visibility configurations for the given tenantId.\nIf no tenantId is defined, we will set the tenant independent app initial visibility configurations.\n", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - app visibility configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableTable<Role, AppId, InitialVisibility> setInitialAppVisibilityConfigurations(@RequestParam(value="tenantId", required=false) @Nullable TenantId tenantId, @RequestBody ImmutableMap<Role, ImmutableMap<AppId, InitialVisibility>> newVisibilityConfigs, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        this._appConfigService.setInitialAppVisibilityConfigsByTenant(tenantId, AppConfigController.convertToTable(newVisibilityConfigs));
        return this._appConfigService.getInitialAppVisibilityConfigsByTenant(tenantId);
    }

    @Nonnull
    private static <R, C, V> ImmutableTable<R, C, V> convertToTable(ImmutableMap<R, ImmutableMap<C, V>> data) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (Map.Entry rowEntry : data.entrySet()) {
            for (Map.Entry columnEntry : ((ImmutableMap)rowEntry.getValue()).entrySet()) {
                builder.put(rowEntry.getKey(), columnEntry.getKey(), columnEntry.getValue());
            }
        }
        return builder.build();
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/visibilities/{role}"})
    @ApiOperation(value="Get the app initial visibility configurations for the given role and tenantId.\nIf no tenentId is defined, we will return the tenant independant app initial visibility configurations.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - app visibility configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableMap<AppId, InitialVisibility> getInitialAppVisibilityConfigurationsByRoleAndTenant(@PathVariable(value="role") String roleAsString, @RequestParam(value="tenantId", required=false) @Nullable TenantId tenantId, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        return this._appConfigService.getInitialAppVisibilityConfigsByTenant(tenantId).row((Object)Role.create((String)roleAsString));
    }

    @RequestMapping(method={RequestMethod.PUT}, path={"/visibilities/{role}"})
    @ApiOperation(value="Set the app initial visibility configurations for the given role and tenantId.\nIf no tenentId is defined, we will set the tenant independant app initial visibility configurations.\n", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - new app visibility configurations returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableMap<AppId, InitialVisibility> setInitialAppVisibilityConfigurationsByRoleAndTenant(@PathVariable(value="role") String roleAsString, @RequestParam(value="tenantId", required=false) @Nullable TenantId tenantId, @RequestBody ImmutableMap<AppId, InitialVisibility> newRoleVisibilityConfigs, @AuthorizedContext AuthorizationContext authContext) {
        authContext.check((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION);
        Role role = Role.create((String)roleAsString);
        this._appConfigService.setInitialAppVisibilityConfigsForRoleAndTenant(role, tenantId, newRoleVisibilityConfigs);
        return this._appConfigService.getInitialAppVisibilityConfigsByTenant(tenantId).row((Object)role);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/availableApps"})
    @ApiOperation(value="Get all available apps for the current user and the given tenantId. If no tenantId is defined, the default tenantId of the current user will be used.", authorizations={@Authorization(value="oauth2")})
    @ApiResponses(value={@ApiResponse(code=200, message="success - All available apps of the current user returned"), @ApiResponse(code=403, message="not authorized")})
    @Nonnull
    public ImmutableList<UserAppConfig> getAvailableApps(@AuthorizedContext AuthorizationContext authContext) {
        return this._appConfigService.getAvailableAppConfigs(authContext);
    }
}

