/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.context.api.business.HomeScreenService;
import de.justsoftware.context.api.business.JustContextService;
import de.justsoftware.context.api.model.JustContext;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonSettingService;
import de.justsoftware.onx.person.shared.model.ProductHintsOption;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JustContextServiceImpl
implements JustContextService {
    private final Settings _settings;
    private final HomeScreenService _homeScreenService;
    private final AppConfigService _appConfigService;
    private final JucoServerVersionService _jucoServerVersionService;
    private final PersonSettingService _personSettingService;
    private final TenantService _tenantService;

    @Autowired
    public JustContextServiceImpl(Settings settings, HomeScreenService homeScreenService, AppConfigService appConfigService, JucoServerVersionService jucoServerVersionService, PersonSettingService personSettingService, TenantService tenantService) {
        this._settings = settings;
        this._homeScreenService = homeScreenService;
        this._jucoServerVersionService = jucoServerVersionService;
        this._appConfigService = appConfigService;
        this._personSettingService = personSettingService;
        this._tenantService = tenantService;
    }

    @Override
    public JustContext getContext(AuthorizationContext authContext) {
        PersonId userId = authContext.getUserId();
        Optional tenantId = authContext.getOptionalTenantId();
        String tenantName = tenantId.map(this::getTenantName).orElse(null);
        ImmutableList availableAppConfigs = this._appConfigService.getAvailableAppConfigs(authContext);
        return new JustContext(authContext.getLocale(), userId, (ImmutableList<UserAppConfig>)availableAppConfigs, this._homeScreenService.getHomeScreenApps(authContext), this._jucoServerVersionService.getCurrentVersion(), tenantId.orElse(null), tenantName, this.getFeatureToggles(), this._personSettingService.getPowerBarSetting(userId), this.getPollingIntervalInSeconds());
    }

    @CheckForNull
    private String getTenantName(TenantId tenantId) {
        return this._tenantService.getTenantById(tenantId).map(Tenant::getName).orElse(null);
    }

    private int getPollingIntervalInSeconds() {
        int pollingInterval = this._settings.getClientPollingInterval();
        int pollingRatio = this._settings.getWorkstreamReadPollRatio();
        return pollingInterval * pollingRatio;
    }

    @Nonnull
    private ImmutableMap<String, Boolean> getFeatureToggles() {
        boolean showProductHintsIcon = this._settings.getShowProductHints() == ProductHintsOption.SHOW_ICON;
        return ImmutableMap.builder().put((Object)"showProductHintsIcon", (Object)showProductHintsIcon).put((Object)"isBrowserPushServiceEnabled", (Object)this._settings.isBrowserPushServiceEnabled()).build();
    }
}

