/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.context.api.business.impl;

import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.context.api.business.ContextThemeService;
import de.justsoftware.context.api.model.ContextAppThemeAttributes;
import de.justsoftware.context.api.model.ContextTheme;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.JustAppType;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.model.UserCoreAppConfig;
import de.justsoftware.onx.appswitcher.model.UserExternalAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ContextThemeServiceImpl
implements ContextThemeService {
    private static final ImmutableSet<ThemeAttributeType> GLOBAL_THEME_ATTRIBUTE_TYPES = ImmutableSet.of((Object)ThemeAttributeType.HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR, (Object)ThemeAttributeType.BRAND_LOGO);
    private final AppConfigService _appConfigService;
    private final ThemeService _deprecatedThemeService;
    private final de.justsoftware.onx.tenantdesign.ThemeService _themeService;
    private final TenantService _tenantService;

    @Autowired
    public ContextThemeServiceImpl(de.justsoftware.onx.tenantdesign.ThemeService tenantThemeService, AppConfigService appConfigService, ThemeService themeService, TenantService tenantService) {
        this._themeService = tenantThemeService;
        this._appConfigService = appConfigService;
        this._deprecatedThemeService = themeService;
        this._tenantService = tenantService;
    }

    @Override
    public ContextTheme getThemeById(ThemeId themeId, AuthorizationContext authContext) {
        Theme designTheme = this._deprecatedThemeService.getById(themeId, (AuthorizationCheckContext)authContext);
        if (designTheme == null) {
            return null;
        }
        ImmutableList availableApps = this._appConfigService.getAvailableAppConfigs(authContext);
        return this.convertDesignTheme(designTheme, (Iterable<UserAppConfig>)availableApps);
    }

    @Override
    @Nonnull
    public ContextTheme getTheme(AuthorizationContext authorizationContext) {
        TenantId tenantId = authorizationContext.getTenantId();
        de.justsoftware.onx.tenantdesign.model.Theme theme = this._themeService.getTheme(tenantId);
        ImmutableMap<String, String> tenantThemeAttributes = this.buildTenantThemeAttributes(tenantId, theme);
        ImmutableMap<String, ContextAppThemeAttributes> appThemeAttributes = this.buildAppThemeAttributes(authorizationContext, theme);
        return new ContextTheme(null, appThemeAttributes, tenantThemeAttributes);
    }

    @Nonnull
    private ImmutableMap<String, ContextAppThemeAttributes> buildAppThemeAttributes(AuthorizationContext authorizationContext, de.justsoftware.onx.tenantdesign.model.Theme theme) {
        ImmutableList availableApps = this._appConfigService.getAvailableAppConfigs(authorizationContext);
        ImmutableMap.Builder appThemeAttributes = ImmutableMap.builder();
        appThemeAttributes.putAll(this.coreAppsWithColorsAndIcons(theme, (ImmutableList<UserAppConfig>)availableApps));
        appThemeAttributes.putAll(this.externalAppsWithColorsAndIcons((ImmutableList<UserAppConfig>)availableApps));
        return appThemeAttributes.build();
    }

    @Nonnull
    private ImmutableMap<String, String> buildTenantThemeAttributes(TenantId tenantId, de.justsoftware.onx.tenantdesign.model.Theme theme) {
        ImmutableMap.Builder tenantThemeAttributes = ImmutableMap.builder();
        tenantThemeAttributes.put((Object)"HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR", (Object)theme.getGlobalHighlightColor());
        String logoId = ((Tenant)this._tenantService.getTenantById(tenantId).orElseThrow(() -> new NoSuchElementException("No Tenant with TenantId:'" + tenantId + "'!"))).getLogoId();
        if (logoId != null) {
            tenantThemeAttributes.put((Object)"TENANT_LOGO_ID", (Object)logoId);
        }
        return tenantThemeAttributes.build();
    }

    private ImmutableMap<String, ContextAppThemeAttributes> coreAppsWithColorsAndIcons(de.justsoftware.onx.tenantdesign.model.Theme theme, ImmutableList<UserAppConfig> availableApps) {
        ImmutableMap.Builder appsWithColorsAndIcons = ImmutableMap.builder();
        theme.getAppColors().entrySet().stream().filter(appColorEntry -> availableApps.stream().anyMatch(appConfig -> appConfig.getAppId().getId().equalsIgnoreCase(((CoreApp)appColorEntry.getKey()).getSimpleName()))).forEach(appColorEntry -> {
            String coreAppSimpleName = ((CoreApp)appColorEntry.getKey()).getSimpleName();
            appsWithColorsAndIcons.put((Object)coreAppSimpleName, (Object)new ContextAppThemeAttributes((String)appColorEntry.getValue(), "url('" + ImageUrlUtil.getAppSwitcherLogoUrl((String)coreAppSimpleName) + "')"));
        });
        return appsWithColorsAndIcons.build();
    }

    private ImmutableMap<String, ContextAppThemeAttributes> externalAppsWithColorsAndIcons(ImmutableList<UserAppConfig> availableApps) {
        List externalApps = availableApps.stream().filter(app -> app.getType() == JustAppType.EXTERNAL).collect(Collectors.toList());
        ImmutableMap.Builder appsWithColorsAndIcons = ImmutableMap.builder();
        for (UserAppConfig externalApp : externalApps) {
            UserExternalAppConfig extApp = (UserExternalAppConfig)externalApp;
            appsWithColorsAndIcons.put((Object)extApp.getAppId().toString(), (Object)new ContextAppThemeAttributes(extApp.getAppColor(), "url('" + ImageUrlUtil.getCustomAppSwitcherLogoUrl((String)extApp.getIcon()) + "')"));
        }
        return appsWithColorsAndIcons.build();
    }

    @Override
    public ContextTheme convertDesignTheme(Theme designTheme, Iterable<UserAppConfig> availableApps) {
        ImmutableMap<String, ContextAppThemeAttributes> appThemeAttributes = this.convertAppThemeAttributes(designTheme, availableApps);
        ImmutableMap<String, String> globalThemeAttributes = this.convertGlobalThemeAttributes(designTheme);
        return new ContextTheme(designTheme.getId(), appThemeAttributes, globalThemeAttributes);
    }

    @Nonnull
    private ImmutableMap<String, ContextAppThemeAttributes> convertAppThemeAttributes(Theme designTheme, Iterable<UserAppConfig> availableApps) {
        ImmutableMap.Builder appThemeAttributes = ImmutableMap.builder();
        AppThemeAttributesVisitor visitor = new AppThemeAttributesVisitor(designTheme);
        for (UserAppConfig app : availableApps) {
            appThemeAttributes.put((Object)app.getAppId().getId(), (Object)((ContextAppThemeAttributes)app.visit((UserAppConfig.Visitor)visitor)));
        }
        return appThemeAttributes.build();
    }

    @Nonnull
    private ImmutableMap<String, String> convertGlobalThemeAttributes(Theme designTheme) {
        ImmutableMap.Builder globalThemeAttributes = ImmutableMap.builder();
        for (ThemeAttributeType themeAttributeType : GLOBAL_THEME_ATTRIBUTE_TYPES) {
            String value;
            ThemeAttribute themeAttribute = designTheme.getAttribute(themeAttributeType);
            if (themeAttribute == null || (value = themeAttribute.getValue()) == null) continue;
            globalThemeAttributes.put((Object)themeAttribute.getAttributeType().name(), (Object)value);
        }
        return globalThemeAttributes.build();
    }

    private static final class AppThemeAttributesVisitor
    implements UserAppConfig.Visitor<ContextAppThemeAttributes> {
        private final AppColorVisitor _color;
        private final AppIconVisitor _icon;

        @ParametersAreNonnullByDefault
        public AppThemeAttributesVisitor(Theme designTheme) {
            this._color = new AppColorVisitor(designTheme);
            this._icon = new AppIconVisitor();
        }

        public ContextAppThemeAttributes visitCoreApp(UserCoreAppConfig config) {
            return new ContextAppThemeAttributes(this._color.visitCoreApp(config), this._icon.visitCoreApp(config));
        }

        public ContextAppThemeAttributes visitExternalApp(UserExternalAppConfig config) {
            return new ContextAppThemeAttributes(this._color.visitExternalApp(config), this._icon.visitExternalApp(config));
        }
    }

    private static final class AppIconVisitor
    implements UserAppConfig.Visitor<String> {
        private AppIconVisitor() {
        }

        public String visitCoreApp(UserCoreAppConfig config) {
            return "url('" + ImageUrlUtil.getAppSwitcherLogoUrl((String)config.getAppId().getId()) + "')";
        }

        public String visitExternalApp(UserExternalAppConfig config) {
            return "url('" + ImageUrlUtil.getCustomAppSwitcherLogoUrl((String)config.getIcon()) + "')";
        }
    }

    private static final class AppColorVisitor
    implements UserAppConfig.Visitor<String> {
        private final Theme _designTheme;

        @ParametersAreNonnullByDefault
        public AppColorVisitor(Theme designTheme) {
            this._designTheme = designTheme;
        }

        public String visitCoreApp(UserCoreAppConfig config) {
            return Optional.ofNullable(this._designTheme.getAttribute(config.getThemeAttributeType())).map(ThemeAttribute::getValue).orElse("#000");
        }

        public String visitExternalApp(UserExternalAppConfig config) {
            return config.getAppColor();
        }
    }
}

