/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Option> shortOpts = new LinkedHashMap<String, Option>();
    private final Map<String, Option> longOpts = new LinkedHashMap<String, Option>();
    private final List<Object> requiredOpts = new ArrayList<Object>();
    private final Map<String, OptionGroup> optionGroups = new HashMap<String, OptionGroup>();

    public Options addOptionGroup(OptionGroup group) {
        if (group.isRequired()) {
            this.requiredOpts.add(group);
        }
        for (Option option : group.getOptions()) {
            option.setRequired(false);
            this.addOption(option);
            this.optionGroups.put(option.getKey(), group);
        }
        return this;
    }

    Collection<OptionGroup> getOptionGroups() {
        return new HashSet<OptionGroup>(this.optionGroups.values());
    }

    public Options addOption(String opt2, String description) {
        this.addOption(opt2, null, false, description);
        return this;
    }

    public Options addOption(String opt2, boolean hasArg, String description) {
        this.addOption(opt2, null, hasArg, description);
        return this;
    }

    public Options addOption(String opt2, String longOpt, boolean hasArg, String description) {
        this.addOption(new Option(opt2, longOpt, hasArg, description));
        return this;
    }

    public Options addOption(Option opt2) {
        String key = opt2.getKey();
        if (opt2.hasLongOpt()) {
            this.longOpts.put(opt2.getLongOpt(), opt2);
        }
        if (opt2.isRequired()) {
            if (this.requiredOpts.contains(key)) {
                this.requiredOpts.remove(this.requiredOpts.indexOf(key));
            }
            this.requiredOpts.add(key);
        }
        this.shortOpts.put(key, opt2);
        return this;
    }

    public Collection<Option> getOptions() {
        return Collections.unmodifiableCollection(this.helpOptions());
    }

    List<Option> helpOptions() {
        return new ArrayList<Option>(this.shortOpts.values());
    }

    public List getRequiredOptions() {
        return Collections.unmodifiableList(this.requiredOpts);
    }

    public Option getOption(String opt2) {
        if (this.shortOpts.containsKey(opt2 = Util.stripLeadingHyphens(opt2))) {
            return this.shortOpts.get(opt2);
        }
        return this.longOpts.get(opt2);
    }

    public List<String> getMatchingOptions(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        ArrayList<String> matchingOpts = new ArrayList<String>();
        if (this.longOpts.keySet().contains(opt2)) {
            return Collections.singletonList(opt2);
        }
        for (String longOpt : this.longOpts.keySet()) {
            if (!longOpt.startsWith(opt2)) continue;
            matchingOpts.add(longOpt);
        }
        return matchingOpts;
    }

    public boolean hasOption(String opt2) {
        return this.shortOpts.containsKey(opt2 = Util.stripLeadingHyphens(opt2)) || this.longOpts.containsKey(opt2);
    }

    public boolean hasLongOption(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        return this.longOpts.containsKey(opt2);
    }

    public boolean hasShortOption(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        return this.shortOpts.containsKey(opt2);
    }

    public OptionGroup getOptionGroup(Option opt2) {
        return this.optionGroups.get(opt2.getKey());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ Options: [ short ");
        buf.append(this.shortOpts.toString());
        buf.append(" ] [ long ");
        buf.append(this.longOpts);
        buf.append(" ]");
        return buf.toString();
    }
}

