/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authentication.configuration;

import de.justsoftware.authentication.configuration.JwtKeyConfiguration;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.KeyMaterialProvider;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class JwtConfiguration {
    private final PublicKeyCache _publicKeyCache;

    public JwtConfiguration(JwtKeyConfiguration keyConfiguration) {
        KeyMaterialProvider privKeyProvider = () -> Optional.ofNullable(keyConfiguration.getPrivateKey());
        KeyMaterialProvider pubKeyProvider = () -> Optional.ofNullable(keyConfiguration.getPublicKey());
        this._publicKeyCache = new PublicKeyCache(privKeyProvider, pubKeyProvider);
    }

    @Nonnull
    @Bean
    public JwtGenerator provideJwtGenerator() {
        return JwtGenerators.createEncryptedJwtGenerator((PublicKeyCache)this._publicKeyCache);
    }
}

