#!/bin/sh

. $(dirname $0)/backup.properties

if [ -n "$FTP_SERVER" ]; then
    start="false"
    # Check now the time the last ftp verification has been executed
    if [ -e $BACKUP_LAST_FTP_VERIFICATION_LOG_FILE ]; then
    last_ftp_verification_at=$(cat $BACKUP_LAST_FTP_VERIFICATION_LOG_FILE)
        # Check the time the last ftp verification ran
    time=$(expr $(date '+%s') - $(date -d "$last_ftp_verification_at" '+%s'))

        # Last ftp backup verification ran more than 25 hours ago=> start new verification
    if [ $time -gt $BACKUP_INTERVAL_TIME_IN_SECONDS ]; then
        start="true"
    fi
    else
    # If no log file exists then start the ftp verification
    start="true"
    fi

    if [ "$start" = "true" ]; then
    echo "Starting ftp verification for $SERVER ..."
    echo "$(date '+%Y-%m-%dT%T')" > $BACKUP_LAST_FTP_VERIFICATION_LOG_FILE

    # Verifying the last db dump backup
    last_db_backup_file=$(ls -tr $BACKUP_MAIN_DIR/db | tail -1)
    last_db_backup_relative="db/$last_db_backup_file"
     echo "Starting ftp verification of $last_db_backup_file for $SERVER/$last_db_backup_relative ..."
    FTP_PASSWORD=$FTP_PASSWORD PASSPHRASE=$PASSPHRASE duplicity verify -v4 --file-to-restore $last_db_backup_relative ftp://$FTP_USERNAME@$FTP_SERVER/$SERVER $BACKUP_MAIN_DIR/db/$last_db_backup_file
    result=$?
    echo "Finished ftp verification of $last_db_backup for $SERVER with result code $result."
    if [ $result -ne 0 ]; then
        exit $result
    fi

    echo "Starting ftp verification of $SERVER/storageserver ..."
    FTP_PASSWORD=$FTP_PASSWORD PASSPHRASE=$PASSPHRASE duplicity verify -v4 --file-to-restore storageserver ftp://$FTP_USERNAME@$FTP_SERVER/$SERVER $BACKUP_MAIN_DIR/storageserver
    result=$?
    echo "Finished ftp verification of $SERVER/storageserver with result code $result."

    echo "Finished ftp verification for $SERVER ..."
    exit $result
    else
    echo "Not starting ftp verification for $SERVER"
    exit 3
    fi

else
    echo "No FTP backup configured for $SERVER"
fi
