/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.common.SolrException;

class BooleanStreamEqualFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final BooleanValue baseExpr;
    private final BooleanValueStream compExpr;
    public static final String name = "equal";
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public BooleanStreamEqualFunction(BooleanValue baseExpr, BooleanValueStream compExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        boolean baseValue = this.baseExpr.getBoolean();
        if (this.baseExpr.exists()) {
            this.compExpr.streamBooleans(compValue -> cons.accept(baseValue == compValue));
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

