/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.model.PagedResult;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ParametersAreNonnullByDefault
@RequestMapping(value={"api/search"})
public class SearchController {
    private final SearchApplicationService _searchApplicationService;

    public SearchController(SearchApplicationService searchApplicationService) {
        this._searchApplicationService = searchApplicationService;
    }

    @Nonnull
    @GetMapping
    public PagedResult<SearchModel> search(AuthorizationContext authCtx, @Nullable @RequestParam(value="query", required=false) String query, @RequestParam(value="offset") int offset, @RequestParam(value="limit") int limit) {
        return this._searchApplicationService.allProfilesAndUserGroups(authCtx, authCtx.getTenantId(), Strings.nullToEmpty((String)query), offset, limit);
    }

    @Nonnull
    @GetMapping(value={"/names"})
    public PagedResult<SearchModel> searchForNames(AuthorizationContext authCtx, @Nullable @RequestParam(value="query", required=false) String query, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @Nullable @RequestParam(value="type", required=false) List<String> types) {
        ImmutableSet setOfTypes = types == null ? ImmutableSet.of() : ImmutableSet.copyOf(types);
        return this._searchApplicationService.searchInNames(authCtx, authCtx.getTenantId(), Strings.nullToEmpty((String)query), setOfTypes, offset, limit);
    }
}

