/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.model.ProfileId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfilePermissionModel {
    private final ProfileId _id;
    private final String _firstName;
    private final String _lastName;
    private final String _title;
    private final String _additionalTitle;
    private final String _imageUrl;
    private final boolean _blocked;
    private final boolean _active;

    @JsonCreator
    public ProfilePermissionModel(@JsonProperty(value="id") ProfileId id, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="title") String title, @JsonProperty(value="additionalTitle") String additionalTitle, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="blocked") boolean blocked, @JsonProperty(value="active") boolean active) {
        this._id = id;
        this._firstName = firstName;
        this._lastName = lastName;
        this._title = title;
        this._additionalTitle = additionalTitle;
        this._imageUrl = imageUrl;
        this._blocked = blocked;
        this._active = active;
    }

    @Nonnull
    public ProfileId getId() {
        return this._id;
    }

    @Nonnull
    public String getFirstName() {
        return this._firstName;
    }

    @Nonnull
    public String getLastName() {
        return this._lastName;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._additionalTitle;
    }

    @Nonnull
    public String getImageUrl() {
        return this._imageUrl;
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public boolean isActive() {
        return this._active;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("firstName", (Object)this._firstName).add("lastName", (Object)this._lastName).add("title", (Object)this._title).add("additionalTitle", (Object)this._additionalTitle).toString();
    }

    @Nonnull
    public static ProfilePermissionModel fromSearchReadModel(ProfileSearchReadModel profile) {
        return new ProfilePermissionModel(profile.getId(), profile.getFirstName(), profile.getLastName(), profile.getTitle(), profile.getAdditionalTitle(), profile.getImageUrl(), profile.isBlocked(), profile.isActive());
    }
}

