/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.security;

import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.notificationservice.security.WebSecurityConfiguration;
import de.justsoftware.notificationservice.security.oAuth.JustOpaqueTokenIntrospector;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u00062\b\b\u0001\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/notificationservice/security/WebSecurityConfiguration;", "", "()V", "configureSecurity", "Lorg/springframework/security/web/SecurityFilterChain;", "checkTokenEndpoint", "", "clientId", "clientSecret", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "Companion", "notification-service"})
public class WebSecurityConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String[] SWAGGER_RESOURCES;
    @NotNull
    private static final String MONITORING_RESOURCE = "/internal/monitoring/**";
    @NotNull
    private static final String MOBILE_PUSH_TOKEN_MIGRATION_RESOURCE = "/internal/mobile-push-token-migration/**";
    @NotNull
    private static final String INTERNAL_RESOURCE = "/internal/notification/**";

    @Bean
    @NotNull
    public SecurityFilterChain configureSecurity(@Value(value="${just.notifications.oauth2.resource.check-token-endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.notifications.oauth2.resource.client-id}") @NotNull String clientId, @Value(value="${just.notifications.oauth2.resource.client-secret}") @NotNull String clientSecret, @NotNull HttpSecurity http, @NotNull JwtVerifier jwtVerifier) {
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(jwtVerifier).applyIgnoreFilterMatcher(WebSecurityConfiguration::configureSecurity$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter, (String)"applyIgnoreFilterMatcher(...)");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter;
        http.sessionManagement(WebSecurityConfiguration::configureSecurity$lambda$1).exceptionHandling(Customizer.withDefaults()).anonymous(Customizer.withDefaults()).csrf(WebSecurityConfiguration::configureSecurity$lambda$2).headers(WebSecurityConfiguration::configureSecurity$lambda$3).authorizeHttpRequests(WebSecurityConfiguration::configureSecurity$lambda$4).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$6(checkTokenEndpoint, clientId, clientSecret, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    private static final boolean configureSecurity$lambda$0(HttpServletRequest it) {
        return new AntPathRequestMatcher(MONITORING_RESOURCE).matches(it);
    }

    private static final void configureSecurity$lambda$1(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    private static final void configureSecurity$lambda$2(CsrfConfigurer it) {
        it.disable();
    }

    private static final void configureSecurity$lambda$3(HeadersConfigurer it) {
        it.cacheControl(Customizer.withDefaults());
    }

    private static final void configureSecurity$lambda$4(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        String[] stringArray = SWAGGER_RESOURCES;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(Arrays.copyOf(stringArray, stringArray.length))).permitAll();
        stringArray = new String[]{MONITORING_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{MOBILE_PUSH_TOKEN_MIGRATION_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        stringArray = new String[]{INTERNAL_RESOURCE};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).permitAll();
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).fullyAuthenticated();
    }

    private static final void configureSecurity$lambda$6$lambda$5(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector($checkTokenEndpoint, $clientId, $clientSecret);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void configureSecurity$lambda$6(String $checkTokenEndpoint, String $clientId, String $clientSecret, OAuth2ResourceServerConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)$checkTokenEndpoint, (String)"$checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)$clientId, (String)"$clientId");
        Intrinsics.checkNotNullParameter((Object)$clientSecret, (String)"$clientSecret");
        it.opaqueToken(arg_0 -> WebSecurityConfiguration.configureSecurity$lambda$6$lambda$5($checkTokenEndpoint, $clientId, $clientSecret, arg_0));
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

