/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell;

import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.shell.NotDirectoryException;
import org.apache.kafka.shell.NotFileException;

public interface MetadataNode {

    public static class FileNode
    implements MetadataNode {
        private String contents;

        void setContents(String contents) {
            this.contents = contents;
        }

        String contents() {
            return this.contents;
        }
    }

    public static class DirectoryNode
    implements MetadataNode {
        private final TreeMap<String, MetadataNode> children = new TreeMap();

        public DirectoryNode mkdirs(String ... names) {
            if (names.length == 0) {
                throw new RuntimeException("Invalid zero-length path");
            }
            DirectoryNode node = this;
            for (int i = 0; i < names.length; ++i) {
                MetadataNode nextNode = node.children.get(names[i]);
                if (nextNode == null) {
                    nextNode = new DirectoryNode();
                    node.children.put(names[i], nextNode);
                } else if (!(nextNode instanceof DirectoryNode)) {
                    throw new NotDirectoryException();
                }
                node = (DirectoryNode)nextNode;
            }
            return node;
        }

        public void rmrf(String ... names) {
            if (names.length == 0) {
                throw new RuntimeException("Invalid zero-length path");
            }
            DirectoryNode node = this;
            for (int i = 0; i < names.length - 1; ++i) {
                MetadataNode nextNode = node.children.get(names[i]);
                if (!(nextNode instanceof DirectoryNode)) {
                    throw new RuntimeException("Unable to locate directory /" + String.join((CharSequence)"/", names));
                }
                node = (DirectoryNode)nextNode;
            }
            node.children.remove(names[names.length - 1]);
        }

        public FileNode create(String name) {
            MetadataNode node = this.children.get(name);
            if (node == null) {
                node = new FileNode();
                this.children.put(name, node);
            } else if (!(node instanceof FileNode)) {
                throw new NotFileException();
            }
            return (FileNode)node;
        }

        public MetadataNode child(String component) {
            return this.children.get(component);
        }

        public NavigableMap<String, MetadataNode> children() {
            return this.children;
        }

        public void addChild(String name, DirectoryNode child) {
            this.children.put(name, child);
        }

        public DirectoryNode directory(String ... names) {
            if (names.length == 0) {
                throw new RuntimeException("Invalid zero-length path");
            }
            DirectoryNode node = this;
            for (int i = 0; i < names.length; ++i) {
                MetadataNode nextNode = node.children.get(names[i]);
                if (!(nextNode instanceof DirectoryNode)) {
                    throw new RuntimeException("Unable to locate directory /" + String.join((CharSequence)"/", names));
                }
                node = (DirectoryNode)nextNode;
            }
            return node;
        }

        public FileNode file(String ... names) {
            if (names.length == 0) {
                throw new RuntimeException("Invalid zero-length path");
            }
            DirectoryNode node = this;
            for (int i = 0; i < names.length - 1; ++i) {
                MetadataNode nextNode = node.children.get(names[i]);
                if (!(nextNode instanceof DirectoryNode)) {
                    throw new RuntimeException("Unable to locate file /" + String.join((CharSequence)"/", names));
                }
                node = (DirectoryNode)nextNode;
            }
            MetadataNode nextNode = node.child(names[names.length - 1]);
            if (!(nextNode instanceof FileNode)) {
                throw new RuntimeException("Unable to locate file /" + String.join((CharSequence)"/", names));
            }
            return (FileNode)nextNode;
        }
    }
}

