/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.mirror.MirrorCheckpointConfig;
import org.apache.kafka.connect.mirror.OffsetSync;

class OffsetSyncStore
implements AutoCloseable {
    private final KafkaConsumer<byte[], byte[]> consumer;
    private final Map<TopicPartition, OffsetSync> offsetSyncs = new HashMap<TopicPartition, OffsetSync>();
    private final TopicPartition offsetSyncTopicPartition;

    OffsetSyncStore(MirrorCheckpointConfig config) {
        this.consumer = new KafkaConsumer(config.offsetSyncsTopicConsumerConfig(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.offsetSyncTopicPartition = new TopicPartition(config.offsetSyncsTopic(), 0);
        this.consumer.assign(Collections.singleton(this.offsetSyncTopicPartition));
    }

    OffsetSyncStore(KafkaConsumer<byte[], byte[]> consumer, TopicPartition offsetSyncTopicPartition) {
        this.consumer = consumer;
        this.offsetSyncTopicPartition = offsetSyncTopicPartition;
    }

    OptionalLong translateDownstream(TopicPartition sourceTopicPartition, long upstreamOffset) {
        Optional<OffsetSync> offsetSync = this.latestOffsetSync(sourceTopicPartition);
        if (offsetSync.isPresent()) {
            if (offsetSync.get().upstreamOffset() > upstreamOffset) {
                return OptionalLong.of(-1L);
            }
            long upstreamStep = upstreamOffset - offsetSync.get().upstreamOffset();
            return OptionalLong.of(offsetSync.get().downstreamOffset() + upstreamStep);
        }
        return OptionalLong.empty();
    }

    synchronized void update(Duration pollTimeout) {
        try {
            this.consumer.poll(pollTimeout).forEach(this::handleRecord);
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() {
        this.consumer.wakeup();
        Utils.closeQuietly(this.consumer, (String)"offset sync store consumer");
    }

    protected void handleRecord(ConsumerRecord<byte[], byte[]> record) {
        OffsetSync offsetSync = OffsetSync.deserializeRecord(record);
        TopicPartition sourceTopicPartition = offsetSync.topicPartition();
        this.offsetSyncs.put(sourceTopicPartition, offsetSync);
    }

    private Optional<OffsetSync> latestOffsetSync(TopicPartition topicPartition) {
        return Optional.ofNullable(this.offsetSyncs.get(topicPartition));
    }
}

