/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search.update;

import de.justsoftware.wikiservice.kafka.AbstractKafkaConsumer;
import de.justsoftware.wikiservice.kafka.KafkaConsumerContext;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.search.SolrService;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001a2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB-\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ)\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0012R\u000e\u0010\u0003\u001a\u00020\u0002X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer;", "Lde/justsoftware/wikiservice/kafka/AbstractKafkaConsumer;", "", "bootstrapServers", "maxChunkSize", "", "maxTimeout", "solrService", "Lde/justsoftware/wikiservice/search/SolrService;", "(Ljava/lang/String;IILde/justsoftware/wikiservice/search/SolrService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "logger", "kotlin.jvm.PlatformType", "process", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "context", "Lde/justsoftware/wikiservice/kafka/KafkaConsumerContext;", "process$wiki_service", "toSupportedAbstractId", "Lde/justsoftware/wikiservice/model/AbstractId;", "id", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nUpdateSearchIndexConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateSearchIndexConsumer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,109:1\n1603#2,9:110\n1855#2:119\n1856#2:121\n1612#2:122\n1#3:120\n37#4,2:123\n*S KotlinDebug\n*F\n+ 1 UpdateSearchIndexConsumer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexConsumer\n*L\n43#1:110,9\n43#1:119\n43#1:121\n43#1:122\n43#1:120\n53#1:123,2\n*E\n"})
public class UpdateSearchIndexConsumer
extends AbstractKafkaConsumer<String, String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;
    private final int maxTimeout;
    @NotNull
    private final SolrService solrService;
    private final Logger logger;

    @Autowired
    public UpdateSearchIndexConsumer(@Value(value="${kafka.bootstrapServers:localhost:9092}") @NotNull String bootstrapServers, @Value(value="${kafka.updateSearchIndex.chunkSize:100}") int maxChunkSize, @Value(value="${kafka.updateSearchIndex.timeout:500}") int maxTimeout, @NotNull SolrService solrService) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)solrService, (String)"solrService");
        super(Companion.createConsumer(bootstrapServers, maxChunkSize, maxTimeout), SetsKt.setOf((Object)"just.wiki-service.search.updateIndex"));
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
        this.maxTimeout = maxTimeout;
        this.solrService = solrService;
        this.logger = LoggerFactory.getLogger(UpdateSearchIndexConsumer.class);
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public void process$wiki_service(@NotNull ConsumerRecords<String, String> records, @NotNull KafkaConsumerContext context) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = (Iterable)records;
            SolrService solrService = this.solrService;
            boolean $i$f$mapNotNull = false;
            void var5_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AbstractId it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ConsumerRecord it = (ConsumerRecord)element$iv$iv;
                boolean bl2 = false;
                Object object = it.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.value()");
                if (this.toSupportedAbstractId((String)object) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            solrService.index((List)destination$iv$iv);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractId toSupportedAbstractId(String id) {
        String[] stringArray = new String[]{","};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)id, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        if (parts.length != 2) {
            return null;
        }
        try {
            stringArray = (String[])(switch (WhenMappings.$EnumSwitchMapping$0[IdType.valueOf((String)parts[0]).ordinal()]) {
                case 1 -> new ChapterId(id);
                case 2 -> new WikiId(id);
                case 3 -> new ArticleId(id);
                default -> null;
            });
        }
        catch (RuntimeException e) {
            this.logger.error("Failed to convert '" + id + "' to valid AbstractId. Skip this record.", (Throwable)e);
            stringArray = null;
        }
        return stringArray;
    }
}

