/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.persistence.model;

import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import java.io.Serializable;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lde/justsoftware/wikiservice/persistence/model/Deletion;", "Ljava/io/Serializable;", "deletionItemId", "Lde/justsoftware/wikiservice/model/ItemId;", "deletedAt", "Ljava/time/Instant;", "deletedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "(Lde/justsoftware/wikiservice/model/ItemId;Ljava/time/Instant;Lde/justsoftware/wikiservice/model/ProfileId;)V", "getDeletedAt", "()Ljava/time/Instant;", "setDeletedAt", "(Ljava/time/Instant;)V", "getDeletedBy", "()Lde/justsoftware/wikiservice/model/ProfileId;", "setDeletedBy", "(Lde/justsoftware/wikiservice/model/ProfileId;)V", "id", "Lde/justsoftware/wikiservice/model/DeletionId;", "getId", "()Lde/justsoftware/wikiservice/model/DeletionId;", "setId", "(Lde/justsoftware/wikiservice/model/DeletionId;)V", "itemId", "Ljava/util/UUID;", "getItemId", "()Ljava/util/UUID;", "setItemId", "(Ljava/util/UUID;)V", "itemType", "Lde/justsoftware/wikiservice/model/IdType;", "getItemType", "()Lde/justsoftware/wikiservice/model/IdType;", "setItemType", "(Lde/justsoftware/wikiservice/model/IdType;)V", "wiki-service"})
public final class Deletion
implements Serializable {
    @NotNull
    private Instant deletedAt;
    @Embedded
    @AttributeOverride(name="id", column=@Column(name="deletedBy"))
    @NotNull
    private ProfileId deletedBy;
    @GenericGenerator(name="DeletionId-generator", strategy="de.justsoftware.wikiservice.model.DeletionId")
    @GeneratedValue(generator="DeletionId-generator")
    @AttributeOverride(name="id", column=@Column(name="id"))
    @EmbeddedId
    @Nullable
    private DeletionId id;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private IdType itemType;
    @NotNull
    private UUID itemId;

    public Deletion(@NotNull ItemId deletionItemId, @NotNull Instant deletedAt, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)deletionItemId, (String)"deletionItemId");
        Intrinsics.checkNotNullParameter((Object)deletedAt, (String)"deletedAt");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        this.deletedAt = deletedAt;
        this.deletedBy = deletedBy;
        this.itemType = deletionItemId.type();
        this.itemId = deletionItemId.getId();
    }

    @NotNull
    public final Instant getDeletedAt() {
        return this.deletedAt;
    }

    public final void setDeletedAt(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.deletedAt = instant;
    }

    @NotNull
    public final ProfileId getDeletedBy() {
        return this.deletedBy;
    }

    public final void setDeletedBy(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"<set-?>");
        this.deletedBy = profileId;
    }

    @Nullable
    public final DeletionId getId() {
        return this.id;
    }

    public final void setId(@Nullable DeletionId deletionId) {
        this.id = deletionId;
    }

    @NotNull
    public final IdType getItemType() {
        return this.itemType;
    }

    public final void setItemType(@NotNull IdType idType) {
        Intrinsics.checkNotNullParameter((Object)idType, (String)"<set-?>");
        this.itemType = idType;
    }

    @NotNull
    public final UUID getItemId() {
        return this.itemId;
    }

    public final void setItemId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.itemId = uUID;
    }

    public Deletion() {
    }
}

