/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.application.SubscriptionApplicationService;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.SubscriptionService;
import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.WikiId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/wikiservice/application/SubscriptionApplicationService;", "", "subscriptionService", "Lde/justsoftware/wikiservice/business/SubscriptionService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "(Lde/justsoftware/wikiservice/business/SubscriptionService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;)V", "read", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "setSubscription", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "isSubscribed", "", "wiki-service"})
public class SubscriptionApplicationService {
    @NotNull
    private final SubscriptionService subscriptionService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;

    @Autowired
    public SubscriptionApplicationService(@NotNull SubscriptionService subscriptionService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService) {
        Intrinsics.checkNotNullParameter((Object)subscriptionService, (String)"subscriptionService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        this.subscriptionService = subscriptionService;
        this.chapterService = chapterService;
        this.articleService = articleService;
    }

    @NotNull
    public SubscriptionDto read(@NotNull WikiId wikiId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadWiki(wikiId);
        return this.subscriptionService.read((ItemId)wikiId, authContext.getUser());
    }

    @NotNull
    public SubscriptionDto read(@NotNull ChapterId chapterId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.chapterService.read(chapterId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return this.subscriptionService.read((ItemId)chapterId, authContext.getUser());
    }

    @NotNull
    public SubscriptionDto read(@NotNull ArticleId articleId, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiId wikiId = this.articleService.read(articleId).getWikiId();
        authContext.checkReadWiki(wikiId);
        return this.subscriptionService.read((ItemId)articleId, authContext.getUser());
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, boolean isSubscribed, @NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[itemId.type().ordinal()]) {
            case 1: {
                authContext.checkReadWiki((WikiId)itemId);
                break;
            }
            case 2: {
                WikiId wikiId = this.chapterService.read((ChapterId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            case 3: {
                WikiId wikiId = this.articleService.read((ArticleId)itemId).getWikiId();
                authContext.checkReadWiki(wikiId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot subscribe to " + itemId);
            }
        }
        return this.subscriptionService.setSubscription(itemId, authContext.getUser(), isSubscribed);
    }
}

