(function() {
     
     // Returns the li tag, the curser of the user is placed in, or null.
     // The tag is returned as CKEDITOR.dom.element
     var findLI = function(editor) {
         var ranges = editor.getSelection().getRanges();
         if (ranges.length == 0) {
             return null;
         }

         // Choose the tag at the beginning of the selection
         var node = ranges[0].startContainer;

         // Search for a parent li tag
         while (node && !(node.is && node.is('li'))) {
             node = node.getParent();
         }

         return node;
     };

     // Updates the state of the Fold-Button.
     // This is called, when the user moves his cursor.
     var onSelectionChange = function(evt) {
         var editor = evt.editor,
             command = editor.getCommand('jc-fold'),
             li = findLI(editor);

         if (li) {
             command.setState(CKEDITOR.TRISTATE_OFF);
         } else {
             command.setState(CKEDITOR.TRISTATE_DISABLED);
         }
     };

    var hasClass = function (elem, className) {
        var attributes = elem.attributes || {};
        var classes = attributes["class"] || "";
        return new RegExp('\\b' + className + '\\b').test(classes);
    };

     CKEDITOR.plugins.add(
         'jc_fold', 
         {
             'hidpi': true,
             'init' : function(editor) {
                 CKEDITOR.addCss(
                     'img.js_fold' +
                         '{' +
                         'background-image: url(' + CKEDITOR.getUrl( this.path + 'images/fold-small.png' ) + ');' +
                         'background-position: center center;' +
                         'background-repeat: no-repeat;' +
                         'width: 16px !important;' +
                         'height: 12px !important;' +
                         '}' );

                 editor.addCommand(
                     'jc-fold', 
                     {
                         'exec' : function(editor) {
                             var element =  editor.document.createElement("i");
                             element.setAttribute('class', 'icon-caret-down fold-link');
                             // CKEditor removes empty i-tags, so we add a 0-width space here
                             element.append(editor.document.createText("\u200b"));

                             editor.insertElement(editor.createFakeElement(element, 'js_fold', 'a', false));
                         },
                         'startDisabled' : true
                     }
                 );

                 editor.ui.addButton && editor.ui.addButton(
                     'jc-fold',
                     {
                         label: BasicConstants.foldList,
                         command: 'jc-fold',
                         icon: this.path + 'images/fold.png'
                     }
                 );

                 editor.on('selectionChange', onSelectionChange);
             },

             afterInit : function( editor ) {
                 var dataProcessor = editor.dataProcessor;
                 var dataFilter = dataProcessor && dataProcessor.dataFilter;

                 if (dataFilter) {
                     dataFilter.addRules({
                         elements :    {
                             i : function(element) {
                                 if (hasClass(element, "fold-link") && hasClass(element, "icon-caret-down")) {
                                     return editor.createFakeParserElement(element, 'js_fold', 'a', false);
                                 }
                                 return undefined;
                             }
                         }
                     });
                 }
             },
             requires : [ 'fakeobjects' ]
         }
     );
})();
