/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.server;

import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.survey.business.SurveyExportService;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.toolbox.http.ContentDispositionUtil;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@ParametersAreNonnullByDefault
public class SurveyExportController {
    private final SurveyExportService _surveyExportService;
    private final SessionAuthorizationContextProvider _authorizationContextProvider;
    private final HttpHeaders _headers;

    @Autowired
    public SurveyExportController(SurveyExportService surveyExportService, SessionAuthorizationContextProvider authorizationContextProvider) {
        this._surveyExportService = surveyExportService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)this.getHeader());
    }

    @Nonnull
    private HttpHeaders getHeader() {
        HttpHeaders headers = new HttpHeaders();
        ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpHeaders)headers).set(arg_0, arg_1), (String)"surveys_results.csv");
        return headers;
    }

    @RequestMapping(value={"/export/survey"}, method={RequestMethod.GET}, produces={"text/comma-separated-values; charset=utf-8"})
    @Nonnull
    public ResponseEntity<String> get(@RequestParam(value="id") Long surveyLongId, HttpServletRequest request) throws IOException {
        return new ResponseEntity((Object)this._surveyExportService.createSurveyResultCSV(new SurveyId(surveyLongId.longValue()), (AuthorizationCheckContextWithUserId)this._authorizationContextProvider.getAuthorizationContextForCurrentUser(request)), (MultiValueMap)this._headers, HttpStatus.OK);
    }
}

