/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.Validatable;
import com.freiheit.toro.common.presentation.client.validator.ValidatableTextBox;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.EnumOptionI18NResolver;
import de.justsoftware.onx.common.presentation.client.ui.EnumRadioButtonWidget;
import de.justsoftware.onx.common.presentation.client.ui.InlineCheckBox;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.presentation.client.ui.UIHtmlPanel;
import de.justsoftware.onx.common.presentation.client.ui.ValidatorPanel;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.presentation.client.ui.CreateOrEditSurveyBaseDataWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyTab;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyResultVisibility;

public class CreateOrEditSurveyBaseDataWidget
extends Composite
implements SurveyTab {
    private static final CreateOrEditSurveyBaseDataWidgetUIBinder UI_BINDER = (CreateOrEditSurveyBaseDataWidgetUIBinder)GWT.create(CreateOrEditSurveyBaseDataWidgetUIBinder.class);
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    @UiField
    ValidatableTextBox _surveyTitle;
    @UiField
    UIHtmlPanel _expiredDatePanel;
    @UiField
    TimestampBox _expiredDate;
    @UiField
    InlineCheckBox _noExpiration;
    @UiField
    FlowPanel _resultVisibilityPanel;
    @UiField
    InlineCheckBox _anonymous;
    @UiField
    InlineCheckBox _participantChangeAnswersAllowed;
    @UiField
    InlineCheckBox _automaticalDeleteOnParticpantLeave;
    @UiField
    InlineCheckBox _redirectToSurveyOnNewMember;
    @UiField
    JCButton _cancelButton;
    @UiField
    JCButton _submitButton;
    @UiField
    Element _redirectToSurveyOnNewMemberConfigElement;
    private final boolean _editMode;
    private final DBSurvey _survey;
    private final ValidatorPanel.ValidatorPanelUtils _validatorPanelUtils = new ValidatorPanel.ValidatorPanelUtils();
    private final ClientFactory _clientFactory;
    private EnumRadioButtonWidget<SurveyResultVisibility> _surveyResultRadioButtons;

    public CreateOrEditSurveyBaseDataWidget(GlobalId parentId, boolean redirectToSurveyOnNewMemberEnabled, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._editMode = false;
        this._survey = new DBSurvey();
        this._survey.setParentId(parentId);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.initUI(redirectToSurveyOnNewMemberEnabled);
        this._anonymous.setEnabled(true);
        this._survey.setResultVisibility(SurveyResultVisibility.PARTICIPANT_AND_ALL_AFTER_EXPIRED_TIME);
        this.updateUIFromSurveyObject();
    }

    public CreateOrEditSurveyBaseDataWidget(DBSurvey survey, boolean redirectToSurveyOnNewMemberEnabled, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._survey = survey;
        this._editMode = true;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this.initUI(redirectToSurveyOnNewMemberEnabled);
        this._anonymous.setEnabled(false);
        this.updateUIFromSurveyObject();
    }

    private void initUI(boolean redirectToSurveyOnNewMemberEnabled) {
        UIObject.setVisible((Element)this._redirectToSurveyOnNewMemberConfigElement, (boolean)redirectToSurveyOnNewMemberEnabled);
        EnumOptionI18NResolver.MapEnumOptionI18NResolver visibilityI18NResolver = new EnumOptionI18NResolver.MapEnumOptionI18NResolver();
        visibilityI18NResolver.addI18NText((Enum)SurveyResultVisibility.PARTICIPANT_AND_ALL_AFTER_EXPIRED_TIME, SURVEY.visibilityParticipantAndAfterExpiratationForAll());
        visibilityI18NResolver.addI18NText((Enum)SurveyResultVisibility.PARTICIPANT, SURVEY.visibilityParticipant());
        visibilityI18NResolver.addI18NText((Enum)SurveyResultVisibility.ADMIN_ONLY, SURVEY.visibilityAdmin());
        this._surveyResultRadioButtons = new EnumRadioButtonWidget(SurveyResultVisibility.class, "surveyResultVisibility", (EnumOptionI18NResolver)visibilityI18NResolver);
        this._resultVisibilityPanel.add((Widget)this._surveyResultRadioButtons);
        this._expiredDate.getDateBox().addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._surveyTitle.setMandatory(true);
        this._surveyTitle.setMaxLength(250);
        this._expiredDatePanel.setValidator((Validatable)this._expiredDate);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._surveyTitle);
        this._validatorPanelUtils.addWrappedValidatable((Widget)this._expiredDatePanel);
    }

    @UiHandler(value={"_noExpiration"})
    public void onNoExpirationValueChange(ValueChangeEvent<Boolean> event) {
        this._expiredDate.setMandatory((Boolean)event.getValue() == false);
        this._expiredDate.setEnabled((Boolean)event.getValue() == false);
    }

    @UiHandler(value={"_submitButton"})
    void handleSubmit(ClickEvent event) {
        this.saveSurvey();
    }

    @UiHandler(value={"_cancelButton"})
    void handleCancel(ClickEvent event) {
        if (this._survey.getId() == null) {
            History.back();
        } else {
            History.newItem((String)SurveyDetailsHandler.token((SurveyId)this._survey.getId(), (boolean)false));
        }
    }

    private void updateSurveyObjectFromUI() {
        this._survey.setTitle(this._surveyTitle.getText());
        if (Boolean.TRUE.equals(this._noExpiration.getValue())) {
            this._survey.setExpiredDate(null);
        } else {
            this._survey.setExpiredDate(this._expiredDate.getValue());
        }
        this._survey.setResultVisibility((SurveyResultVisibility)this._surveyResultRadioButtons.getValue());
        this._survey.setAnonym(Boolean.TRUE.equals(this._anonymous.getValue()));
        this._survey.setParticipantMayModify(Boolean.TRUE.equals(this._participantChangeAnswersAllowed.getValue()));
        this._survey.setAutoDeleteAnswer(Boolean.TRUE.equals(this._automaticalDeleteOnParticpantLeave.getValue()));
        this._survey.setRedirectOnNewMember(Boolean.TRUE.equals(this._redirectToSurveyOnNewMember.getValue()));
    }

    private void updateUIFromSurveyObject() {
        this._surveyTitle.setText(this._survey.getTitle());
        if (this._survey.getExpiredDate() == null) {
            this._expiredDate.setEnabled(false);
            this._noExpiration.setValue(Boolean.TRUE);
        } else {
            this._expiredDate.setEnabled(true);
            this._noExpiration.setValue(Boolean.FALSE);
            this._expiredDate.setValue((Object)this._survey.getExpiredDate());
        }
        this._surveyResultRadioButtons.setValue((Object)this._survey.getResultVisibility());
        this._anonymous.setValue(Boolean.valueOf(this._survey.isAnonym()));
        this._participantChangeAnswersAllowed.setValue(Boolean.valueOf(this._survey.isParticipantMayModify()));
        this._automaticalDeleteOnParticpantLeave.setValue(Boolean.valueOf(this._survey.isAutoDeleteAnswer()));
        this._redirectToSurveyOnNewMember.setValue(Boolean.valueOf(this._survey.isRedirectOnNewMember()));
    }

    private void saveSurvey() {
        try {
            this._validatorPanelUtils.validate();
        }
        catch (ValidationException e) {
            return;
        }
        LoadingDialog loadingDialog = new LoadingDialog();
        loadingDialog.center();
        this.updateSurveyObjectFromUI();
        if (!this._editMode) {
            this._clientFactory.surveyClientFactory().controller().insertSurveyBaseData(this._survey, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this._clientFactory.surveyClientFactory().controller().updateSurveyBaseData(this._survey, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void onTabShow() {
    }
}

