/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.WorkstreamSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.WorkstreamSearchResultBadgeModel;
import de.justsoftware.onx.workstream.presentation.client.ui.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.i18n.WorkstreamConstants;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentVisitor;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class WorkstreamSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    private static final WorkstreamConstants WORKSTREAM = I18nMediator.WORKSTREAM;

    public WorkstreamSearchResultBadgePresenter(@Nonnull ClientFactory clientFactory, @Nonnull WorkstreamSearchResultBadgeModel model, boolean displayPublicationDate, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this.setImage(model);
        if (displayParents) {
            this.setParent(model.getLinkedProfile(), (List)model.getLinkedEntities());
        } else {
            this._view.setParentEnabled(false);
        }
        this.setLastChangeDate(model.getModifyDate());
        this.addPublicationDate(displayPublicationDate, model.getPublicationDate());
        HashMap badgeFieldByName = WorkstreamSearchResultBadgePresenter.mapBadgeFieldByName((Collection)model.getFoundInFields());
        BadgeField contentField = (BadgeField)badgeFieldByName.get("content");
        BadgeField titleField = (BadgeField)badgeFieldByName.get("name");
        badgeFieldByName.remove("name");
        this.addContent(model, contentField, titleField);
        this.addAuthor(model);
        this.addAttachment(model);
        this._view.addFoundIn(badgeFieldByName.values(), (FieldNameResolver)new WorkstreamFieldNameResolver());
    }

    private void addContent(@Nonnull WorkstreamSearchResultBadgeModel model, BadgeField contentField, @Nullable BadgeField titleField) {
        FlowPanel microblogTextWidget = new FlowPanel();
        String targetHistoryToken = WorkstreamMessageHandler.token((WorkstreamMessageId)((WorkstreamMessageId)model.getId()));
        String title = model.getName();
        String displayedPostingText = title != null ? title : (titleField != null ? titleField.getContent() : contentField.getContent());
        Date archiveDate = model.getArchivedDate();
        if (archiveDate != null) {
            IconAnchor iconAnchor = EntityUtils.createArchivedIconAndTooltip((Date)archiveDate).createIconAnchor(targetHistoryToken, null);
            microblogTextWidget.add((Widget)iconAnchor);
            microblogTextWidget.add((Widget)new InlineLabel(" "));
            if (StringUtil.isEmpty((String)displayedPostingText)) {
                microblogTextWidget.add((Widget)new InlineHyperlink(iconAnchor.getTitle(), targetHistoryToken));
            }
        }
        IconAnchor microblogLink = new IconAnchor();
        microblogLink.setText(I18nMediator.SEARCH.toMicroblogPosting());
        microblogLink.setIcon(IconType.SHARE_ALT);
        microblogLink.setTargetHistoryToken(targetHistoryToken);
        microblogLink.addStyleName("more-link");
        InlineHyperlink posting = null;
        if (!StringUtil.isEmpty((String)displayedPostingText)) {
            posting = new InlineHyperlink(HTMLUtil.highlightedHtmlEscape((String)displayedPostingText), targetHistoryToken);
            posting.addStyleName("content");
            microblogTextWidget.add((Widget)posting);
        } else {
            microblogTextWidget.add((Widget)microblogLink);
        }
        this._view.setTitleWidget((Widget)microblogTextWidget, (Widget)MoreObjects.firstNonNull((Object)posting, (Object)microblogLink));
    }

    private void addAttachment(@Nonnull WorkstreamSearchResultBadgeModel model) {
        Collection attachments = model.getAttachments();
        FlowPanel attachmentsPanel = new FlowPanel();
        boolean hasAttachment = false;
        WorkstreamAttachmentSearchBadgeVisitor workstreamAttachmentSearchBadgeVisitor = new WorkstreamAttachmentSearchBadgeVisitor();
        for (Attachment attachment : attachments) {
            Optional attachmentWidget = (Optional)attachment.accept((AttachmentVisitor)workstreamAttachmentSearchBadgeVisitor);
            if (!attachmentWidget.isPresent()) continue;
            if (hasAttachment) {
                attachmentsPanel.add((Widget)new InlineLabel(", "));
            }
            attachmentsPanel.add((Widget)attachmentWidget.get());
            hasAttachment = true;
        }
        if (hasAttachment) {
            this._view.addDetails(I18nMediator.WORKSTREAM.attachments(), (Widget)attachmentsPanel);
        }
    }

    private void addAuthor(@Nonnull WorkstreamSearchResultBadgeModel model) {
        PersonTeaserModel author = model.getAuthor();
        if (author != null) {
            this._view.addDetails(WORKSTREAM.author(), PersonUtil.profileLink((PersonTeaserModel)author, (ClientFactory)this._clientFactory, (PersonUtil.PopupOption)PersonUtil.PopupOption.WITH_POPUP));
        }
    }

    private void setIcon(@Nonnull IconType iconType, @Nonnull WorkstreamMessageId id) {
        JCIconOnlyAnchor icon = new JCIconOnlyAnchor(iconType, WorkstreamMessageHandler.token((WorkstreamMessageId)id));
        icon.addStyleName("action");
        icon.addStyleName("badgeIcon");
        icon.addStyleName("app-news-color");
        icon.setTitle(WORKSTREAM.microblogPosting());
        this._view.setIconWidget((Widget)icon);
    }

    private void setImage(@Nonnull WorkstreamSearchResultBadgeModel model) {
        if (WorkstreamMessageType.MICROBLOG_POSTING.equals((Object)model.getWorkstreamMessageType())) {
            this.setIcon(model.getIcon(), (WorkstreamMessageId)model.getId());
        }
    }
}

