/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchFilterToggleView;
import javax.annotation.Nonnull;

public class SearchFilterTogglePresenter
implements SearchFilterToggleView.Presenter {
    private final SearchFilterToggleView _view;
    private final ClientFactory _clientFactory;
    private boolean _showFilter;

    public SearchFilterTogglePresenter(ClientFactory clientFactory, SearchFilterToggleView view) {
        this._clientFactory = clientFactory;
        boolean enableToggle = !clientFactory.getHostPropertiesBean().isCollapseToRestrictingFilters();
        this._view = view;
        this._view.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setEnabled(enableToggle);
    }

    @Nonnull
    private String getFilterToggleText(boolean showFilter) {
        SearchConstants searchConstants = this._clientFactory.searchFactory().getSearchConstants();
        return showFilter ? searchConstants.hideSearchFilter() : searchConstants.showSearchFilter();
    }

    public void toggleFilter() {
        this._showFilter = !this._showFilter;
        this._view.setText(this.getFilterToggleText(this._showFilter));
    }

    public boolean showFilter() {
        return this._showFilter;
    }

    public boolean isEnabled() {
        return this._view.isVisible();
    }

    public IsWidget getView() {
        return this._view;
    }

    public String getToggleText() {
        return this._view.getText();
    }

    public void setEnabled(boolean enabled) {
        this._showFilter = !enabled;
        this._view.setText(this.getFilterToggleText(this._showFilter));
        this._view.setVisible(enabled);
    }
}

