/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.shared.i18n.SearchConstants;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.shared.model.HostPropertiesBean;
import de.justsoftware.onx.container.presentation.client.EntityClientFactory;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.searchnew.presentation.client.SingleSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractSingleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchContextFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntitySearchContextFilterDataProvider
implements AbstractSingleSelectionFilterPresenter.SingleSelectionFilterLinkDataProvider<SearchContextFacet> {
    private final EntityClientFactory _entityClientFactory;
    private final SearchConstants _searchConstants;
    private final HostPropertiesBean _hostPropertiesBean;

    public EntitySearchContextFilterDataProvider(EntityClientFactory entityClientFactory, SearchConstants searchConstants, HostPropertiesBean hostPropertiesBean) {
        this._entityClientFactory = entityClientFactory;
        this._searchConstants = searchConstants;
        this._hostPropertiesBean = hostPropertiesBean;
    }

    public void withSelectionLinks(SearchParameters parameters, AbstractSingleSelectionFilterPresenter.SelectionLinksAvailableCallback<SearchContextFacet> callback) {
        SearchContext selectedContext = parameters.getSearchContext();
        EntityId selectedEntityId = parameters.getContextEntityId();
        if (selectedEntityId != null) {
            this._entityClientFactory.controller().getInfoById(selectedEntityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void addFilterLink(ImmutableList.Builder<SingleSelectionFilterLink<SearchContextFacet>> linkList, IconType icon, String label, SearchContext linkSearchContext, EntityId entityId, @Nullable SearchContext selectedContext, boolean defaultSelection) {
        Optional searchContextFacet = SearchContextFacet.forContext((SearchContext)linkSearchContext, (EntityId)entityId, null);
        if (searchContextFacet.isPresent()) {
            linkList.add((Object)new SingleSelectionFilterLink(icon, label, selectedContext == linkSearchContext, (Object)((SearchContextFacet)searchContextFacet.get()), defaultSelection));
        }
    }

    public boolean isFilterApplicable(SearchParameters searchParameters) {
        SearchContext selectedContext = searchParameters.getSearchContext();
        EntityId selectedEntityId = searchParameters.getContextEntityId();
        return selectedEntityId != null && selectedContext != null && !selectedContext.isMyContentContext() && this._hostPropertiesBean.isSearchContextShown();
    }

    public String getFilterHeader() {
        return this._searchConstants.searchIn();
    }

    public SearchParameters withSelection(SearchParameters searchParameters, SearchContextFacet searchFacet) {
        return searchParameters.withSearchContext(searchFacet.getSearchContext());
    }

    public boolean isRestrictionSelected(SearchParameters searchParameters) {
        return this._hostPropertiesBean.isAlwaysShowSearchContextFilter() || searchParameters.getSearchContextOrEntirePlatform() != SearchContext.ENTIRE_PLATFORM;
    }
}

