/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.client.ui;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.event.HistoryChangedEvent;
import com.freiheit.toro.client.mediator.HistoryTokenState;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewDialogBox;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.presentation.client.EntityChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityDeletedOrMemberRoleChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityDetailsNotVisibleEvent;
import de.justsoftware.onx.container.presentation.client.EntityTitleChangedEvent;
import de.justsoftware.onx.container.presentation.client.MyEntitySubscriptionsChangedEvent;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MenuCreateEntityInfo;
import de.justsoftware.onx.menu.presentation.client.model.MenuState;
import de.justsoftware.onx.menu.presentation.client.model.ToggleLeftMenuStateClientEvent;
import de.justsoftware.onx.menu.presentation.client.ui.MenuDrawerControlWidget;
import de.justsoftware.onx.menu.presentation.client.ui.MenuPanel;
import de.justsoftware.onx.menu.presentation.client.ui.MenuToggleButton;
import de.justsoftware.onx.menu.presentation.client.ui.MenuWidget;
import de.justsoftware.onx.menu.presentation.client.ui.ReactSearchLeftMenuWidget;
import de.justsoftware.onx.menu.presentation.shared.MenuRemoteServiceAsync;
import de.justsoftware.onx.searchnew.presentation.client.SearchBacklinkTokenUpdateEvent;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import java.util.Date;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MenuWidget
extends FlowPanel {
    private static final String ACTION_STYLENAME = "leftmenu-title-action";
    private final ClientFactory _clientFactory;
    private final RefreshTeaserTrigger _teaserRefreshTrigger;
    private final MenuPanel _pageMenuContent;
    private final MenuDrawerControlWidget _menuSliderWidget;
    private final MenuToggleButton _pageMenuToggleButton;
    private final MenuToggleButton _wikiMenuToggleButton;
    private final Element _connectElement;
    private FlowPanel _pageLeftMenu;
    private MenuState _state;
    private MenuType _currentMenuType;
    private EventManager.EventManagerHelper _eventManagerHelper;
    private ReactSearchLeftMenuWidget _searchLeftMenu;
    private String _searchBacklinkToken;

    public MenuWidget(@Nullable Element connectElement, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._menuSliderWidget = new MenuDrawerControlWidget(clientFactory);
        this._connectElement = connectElement;
        this._pageMenuToggleButton = new MenuToggleButton(this._clientFactory);
        this._wikiMenuToggleButton = new MenuToggleButton(this._clientFactory);
        this.updateMenuState(MenuState.OPEN);
        this._pageMenuContent = new MenuPanel(clientFactory);
        this.setMenuToPanel();
        this._teaserRefreshTrigger = new BundledRequestRefreshTeaserTrigger(this);
    }

    protected void onAttach() {
        super.onAttach();
        this._eventManagerHelper = this._clientFactory.eventManager().helper();
        this._eventManagerHelper.registerListener(HistoryChangedEvent.class, e -> this.setMenuToPanel());
        this._eventManagerHelper.registerListener(SearchBacklinkTokenUpdateEvent.class, e -> {
            this._searchBacklinkToken = e.getBacklinkToken();
            if (this._searchLeftMenu != null) {
                this._searchLeftMenu.updateBacklinkToken(this._searchBacklinkToken);
            }
        });
    }

    protected void onDetach() {
        super.onDetach();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }

    @Nonnull
    private FlowPanel createLeftMenu() {
        FlowPanel leftMenu = new FlowPanel();
        leftMenu.addStyleName("leftmenu");
        leftMenu.addStyleName("app-bg-color");
        FlowPanel titleWidget = new FlowPanel();
        titleWidget.addStyleName("leftmenu-title");
        leftMenu.add((Widget)titleWidget);
        FlowPanel menuItems = new FlowPanel();
        menuItems.addStyleName("leftmenu-items");
        leftMenu.add((Widget)menuItems);
        menuItems.add((Widget)this._pageMenuContent);
        boolean calendarAdded = this.addCalendarAction(titleWidget);
        titleWidget.add((Widget)this._pageMenuToggleButton);
        this.addCreateEntityAction(titleWidget, calendarAdded ? 2 : 1, arg_0 -> ((MenuRemoteServiceAsync)this._clientFactory.menuFactory().remoteService()).getPageMenuCreateEntityInfo(arg_0));
        return leftMenu;
    }

    private void setMenuToPanel() {
        HistoryTokenState tokenState = this._clientFactory.historyManager().getCurrentHistoryTokenState();
        if (tokenState != null && tokenState.getTokenIdAndParams().getTokenId() == HistoryToken.SEARCH_TEXT) {
            this.setSearchMenuToPanel();
        } else {
            this.setAppDependentMenuToPanel(MenuType.PAGE_MENU);
        }
    }

    private void setAppDependentMenuToPanel(MenuType menuType) {
        if (this._currentMenuType == menuType) {
            return;
        }
        boolean refreshNeeded = this._currentMenuType != null;
        FlowPanel menu = this.getOrCreatePageMenu();
        this.clear();
        this.add((Widget)menu);
        this.add((Widget)this._menuSliderWidget);
        this._currentMenuType = menuType;
        this.toggleLeftMenuCssClasses(this._state);
        if (refreshNeeded && this._teaserRefreshTrigger != null) {
            this._teaserRefreshTrigger.refreshTeasers();
        }
    }

    @Nonnull
    private FlowPanel getOrCreatePageMenu() {
        if (this._pageLeftMenu == null) {
            this._pageLeftMenu = this.createLeftMenu();
        }
        return this._pageLeftMenu;
    }

    private void setSearchMenuToPanel() {
        if (this._currentMenuType == MenuType.SEARCH_MENU) {
            return;
        }
        if (this._searchLeftMenu == null) {
            this._searchLeftMenu = new ReactSearchLeftMenuWidget(this._clientFactory, this._searchBacklinkToken);
        }
        this.clear();
        this.add((Widget)this._searchLeftMenu);
        this._currentMenuType = MenuType.SEARCH_MENU;
        this.toggleLeftMenuCssClasses(null);
    }

    private boolean addCalendarAction(FlowPanel titleWidget) {
        if (!HostPropertiesMediator.getHostPropertiesBean().isHeaderCalendarIconEnabled()) {
            return false;
        }
        EntityType entityType = HostPropertiesMediator.getHostPropertiesBean().getHeaderCalendarEntityType();
        boolean creatingAllowed = LoginManagerImpl.getInstance().may((Action)Actions.entityCreate((EntityType)entityType));
        SearchParameters searchParameters = new SearchParameters(null, FilterTypes.getByEntityType((EntityType)entityType), SearchContext.MY_CONTENT, null, null, SortType.TIME_ASCENDING, null, SearchProviderId.JUCO_ID, (SearchFacetParameters)StaticSearchFacetParameters.DEFAULT_FACETS);
        FocusPanel calendarPanel = new FocusPanel();
        calendarPanel.add((Widget)new Icon(IconType.CALENDAR));
        calendarPanel.setTitle(I18nMediator.getEntityConstantsByEntityType((EntityType)entityType).monthViewLink());
        calendarPanel.addStyleName(ACTION_STYLENAME);
        calendarPanel.addClickHandler(e -> CalendarViewDialogBox.showCalendarViewDialogBox((ClientFactory)this._clientFactory, (boolean)creatingAllowed, (SearchParameters)searchParameters, (Date)new Date(), (EntityType)entityType, (boolean)true));
        titleWidget.add((Widget)calendarPanel);
        return true;
    }

    private void updateMenuState(MenuState targetState) {
        this._state = targetState;
        this.toggleLeftMenuCssClasses(this._state);
        BasicConstants basicConstants = this._clientFactory.localizedMessages().basicConstants();
        String buttonTitle = this._state == MenuState.OPEN ? basicConstants.hideMenu() : basicConstants.showMenu();
        this._pageMenuToggleButton.setTitle(buttonTitle);
        this._wikiMenuToggleButton.setTitle(buttonTitle);
    }

    private void toggleLeftMenuCssClasses(@Nullable MenuState state) {
        if (this._connectElement != null) {
            UIObject.setStyleName((Element)this._connectElement, (String)"left-menu-collapsed", (boolean)MenuState.COLLAPSED.equals((Object)state));
            UIObject.setStyleName((Element)this._connectElement, (String)"left-menu-drawer", (boolean)MenuState.DRAWER.equals((Object)state));
            UIObject.setStyleName((Element)this._connectElement, (String)"left-menu-open", (boolean)MenuState.OPEN.equals((Object)state));
        }
    }

    private void handleToggleLeftMenuState(ToggleLeftMenuStateClientEvent event) {
        switch (2.$SwitchMap$de$justsoftware$onx$menu$presentation$client$model$ToggleLeftMenuStateClientEvent[event.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                this.updateMenuState(event.getTargetState());
                break;
            }
            case 4: {
                if (!MenuState.DRAWER.equals((Object)this._state)) break;
                this.updateMenuState(event.getTargetState());
            }
        }
    }

    private void addCreateEntityAction(FlowPanel titleWidget, int beforeIndex, Consumer<AsyncCallback<MenuCreateEntityInfo>> loader) {
        loader.accept((AsyncCallback<MenuCreateEntityInfo>)new /* Unavailable Anonymous Inner Class!! */);
    }

    @CheckForNull
    private MenuPanel getCurrentMenuPanel() {
        switch (2.$SwitchMap$de$justsoftware$onx$menu$presentation$client$ui$MenuWidget$MenuType[this._currentMenuType.ordinal()]) {
            case 1: {
                return this._pageMenuContent;
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    protected void onLoad() {
        this._clientFactory.eventManager().helper().registerListener(EntityDeletedOrMemberRoleChangedEvent.class, e -> this.refreshMenu(e.getEntityType())).registerListener(EntityTitleChangedEvent.class, e -> this.refreshMenu(e.getEntityType())).registerListener(EntityChangedEvent.class, e -> this.refreshMenu(e.getEntityType())).registerListener(MyEntitySubscriptionsChangedEvent.class, e -> this.refreshMenu(e.getEntityType())).registerListener(EntityDetailsNotVisibleEvent.class, e -> {
            MenuPanel currentMenuPanel = this.getCurrentMenuPanel();
            if (currentMenuPanel != null) {
                currentMenuPanel.removeEntityLinks(e.getEntityId());
            }
        }).registerListener(ToggleLeftMenuStateClientEvent.class, arg_0 -> this.handleToggleLeftMenuState(arg_0));
        this._teaserRefreshTrigger.onLoad();
        super.onLoad();
    }

    private void refreshMenu(@Nullable EntityType entityType) {
        MenuPanel currentMenuPanel = this.getCurrentMenuPanel();
        if (currentMenuPanel == null) {
            return;
        }
        if (entityType != null) {
            currentMenuPanel.refreshTeasersForEntityType(entityType);
        } else {
            this._teaserRefreshTrigger.refreshTeasers();
        }
    }

    protected void onUnload() {
        this._clientFactory.eventManager().helper().onUnloadRemoveHandlersFromManager();
        this._teaserRefreshTrigger.onUnload();
        super.onUnload();
    }
}

