/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.client.presenter;

import com.freiheit.toro.account.presentation.client.ProfileStatusEvent;
import com.freiheit.toro.account.presentation.ui.settings.SettingsHandler;
import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.freiheit.toro.client.ui.layout.ChangeLanguagePopup;
import com.freiheit.toro.common.shared.model.Language;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.administration.presentation.client.ui.AdministrationHandler;
import de.justsoftware.onx.administration.presentation.client.ui.AdministrationView;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.presentation.client.ui.ReactProfileComponent;
import de.justsoftware.onx.menu.presentation.client.ui.ProfileMenuView;
import de.justsoftware.onx.menu.presentation.shared.MenuRemoteService;
import de.justsoftware.onx.menu.presentation.shared.model.ProfileMenu;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class ProfileMenuPresenterImpl
implements ProfileMenuView.ProfileMenuPresenter {
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final ProfileMenuView _view;
    private final ClientFactory _clientFactory;
    private boolean _loading;
    private final ClickHandler _logoutHandler;
    private final ClickHandler _productHintHandler = new /* Unavailable Anonymous Inner Class!! */;

    public ProfileMenuPresenterImpl(ClientFactory clientFactory, EventManager eventManager) {
        this._clientFactory = clientFactory;
        this._eventManagerHelper = new EventManager.EventManagerHelper(eventManager);
        this._view = this._clientFactory.personClientFactory().getProfileMenuView((ProfileMenuView.ProfileMenuPresenter)this);
        this._view.setVisible(false);
        this._loading = false;
        this._logoutHandler = event -> ProfileMenuPresenterImpl.logout();
        this.updateWidget();
    }

    @Nonnull
    public static native void logout();

    private void addUserSection(PersonTeaserModel person, ImmutableList<Language> languages, ImmutableSet<Action> allowedSystemActions, ImmutableList<AppId> availableAppIds) {
        ProfileMenuView.ProfileMenuSectionView profileSectionView = this._view.addSection(ProfileMenuView.SectionPosition.RIGHT, person.getFullName());
        ProfileConstants profileConstants = this._clientFactory.localizedMessages().profileConstants();
        com.freiheit.toro.common.shared.i18n.BasicConstants oldBasicConstants = this._clientFactory.localizedMessages().basicConstantsOld();
        BasicConstants basicConstants = this._clientFactory.localizedMessages().basicConstants();
        profileSectionView.addOption(profileConstants.myProfile(), ReactProfileComponent.token((PersonId)((PersonId)person.getId())));
        profileSectionView.addOption(oldBasicConstants.einstellungen(), SettingsHandler.token((HistoryManager)this._clientFactory.historyManager()));
        if (languages.size() > 1) {
            profileSectionView.addOption(oldBasicConstants.language(), event -> ChangeLanguagePopup.showLanguagePopup((List)languages));
        }
        if (this.hasAccessToAdminApp(allowedSystemActions, availableAppIds)) {
            profileSectionView.addSpacer();
            profileSectionView.addOption(basicConstants.addUser(), "/admin/user-add");
        }
        if (this.hasAccessToAdminApp(allowedSystemActions, availableAppIds)) {
            profileSectionView.addSpacer();
            profileSectionView.addOption(basicConstants.hostNavigation(), "/admin");
        }
        profileSectionView.addSpacer();
        profileSectionView.addOption(basicConstants.aboutJust(), "/aboutjust");
        profileSectionView.addOption(oldBasicConstants.ausloggen(), this._logoutHandler);
    }

    private boolean hasAccessToAdminApp(ImmutableSet<Action> allowedSystemActions, ImmutableList<AppId> availableAppIds) {
        return allowedSystemActions.contains((Object)StaticAction.ADMIN_MANAGE_TENANTS) && availableAppIds.contains((Object)CoreApp.ADMIN.getAppId());
    }

    private void addSystemSection(ImmutableSet<Action> allowedSystemActions) {
        if (Sets.intersection(allowedSystemActions, (Set)MenuRemoteService.SYSTEM_FUNCTION_ACTIONS).isEmpty()) {
            return;
        }
        ProfileConstants profileConstants = this._clientFactory.localizedMessages().profileConstants();
        ProfileMenuView.ProfileMenuSectionView profileSectionView = this._view.addSection(ProfileMenuView.SectionPosition.LEFT, profileConstants.systemFunctions());
        if (allowedSystemActions.contains((Object)StaticAction.ADMIN_MODIFY_DEFAULT_DESIGN)) {
            profileSectionView.addOption(profileConstants.globalDesign(), AdministrationHandler.createAdminstrationToken((HistoryManager)this._clientFactory.historyManager(), (AdministrationView.AdministrationTab)AdministrationView.AdministrationTab.DESIGN));
        }
        if (!Sets.intersection(allowedSystemActions, (Set)MenuRemoteService.SUPER_ADMIN_PANEL_ACTIONS).isEmpty()) {
            String superadminFeatures = this._clientFactory.localizedMessages().basicConstants().superadminFeatures();
            profileSectionView.addOption(superadminFeatures, (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateSections(ProfileMenu menu) {
        this._view.clearSections();
        PersonTeaserModel person = menu.getPerson();
        this._view.setVisible(true);
        this._view.setUser(person.getFullName(), ReactProfileComponent.token((PersonId)((PersonId)person.getId())));
        this._view.setUserImage(ImageUrlUtil.getFullSmallUserImageUrl((String)person.getLogo()), ReactProfileComponent.token((PersonId)((PersonId)person.getId())));
        this.addUserSection(person, menu.getLanguages(), menu.getAllowedSystemActions(), menu.getAvailableAppIds());
        this.addSystemSection(menu.getAllowedSystemActions());
    }

    private void updateWidget() {
        if (this._loading) {
            return;
        }
        this._loading = true;
        this._view.showLoadingIcon(true);
        this._clientFactory.menuFactory().remoteService().getProfileMenu((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onViewAttach() {
        this._eventManagerHelper.registerListener(ProfileStatusEvent.class, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onViewDetach() {
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }

    public IsWidget getView() {
        return this._view;
    }

    public void onMenuOpen() {
        this.updateWidget();
    }
}

